/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.data;

import com.tvd12.ezyfox.io.EzyCollections;
import com.tvd12.ezyhttp.core.constant.HttpMethod;
import com.tvd12.ezyhttp.server.core.manager.FeatureURIManager;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AdminRolesProxy {
    private boolean superAdmin;
    private boolean specialAdmin;
    private FeatureURIManager featureUriManager;
    private Map<String, Set<HttpMethod>> accessibleMethodsByUri;

    public boolean isAccessible(String uri) {
        return this.isAccessible(uri, HttpMethod.GET);
    }

    public boolean isAccessible(String uri, String method) {
        return this.isAccessible(uri, HttpMethod.valueOf((String)method));
    }

    public boolean isAccessible(String uri, HttpMethod method) {
        if (this.specialAdmin) {
            return true;
        }
        String feature = this.featureUriManager.getFeatureByURI(method, uri);
        if (feature == null) {
            return true;
        }
        Set methods = this.accessibleMethodsByUri.getOrDefault(uri, Collections.emptySet());
        return methods.contains(method);
    }

    public boolean isAccessibleAny(List<String> urls) {
        for (String url : urls) {
            if (!this.isAccessible(url)) continue;
            return true;
        }
        return false;
    }

    public boolean isAccessibleAll(List<String> urls) {
        for (String url : urls) {
            if (this.isAccessible(url)) continue;
            return false;
        }
        return true;
    }

    public static AdminRolesProxy create(Set<Long> roleIds, long superAdminRoleId, Set<Long> specialRoleIds, FeatureURIManager featureUriManager, Map<Long, Map<String, Map<String, Set<HttpMethod>>>> methodsUriMapByFeatureByRoleId) {
        HashMap<String, Set<HttpMethod>> accessibleMethodsByUri = new HashMap<String, Set<HttpMethod>>();
        for (Long roleId : roleIds) {
            Map<String, Map<String, Set<HttpMethod>>> methodsUriMapByFeature = methodsUriMapByFeatureByRoleId.get(roleId);
            if (methodsUriMapByFeature == null) continue;
            for (Map<String, Set<HttpMethod>> methodsUriMap : methodsUriMapByFeature.values()) {
                for (Map.Entry<String, Set<HttpMethod>> entry : methodsUriMap.entrySet()) {
                    accessibleMethodsByUri.compute(entry.getKey(), (k, v) -> {
                        if (v == null) {
                            return (Set)entry.getValue();
                        }
                        HashSet methods = new HashSet(v);
                        methods.addAll((Collection)entry.getValue());
                        return methods;
                    });
                }
            }
        }
        return AdminRolesProxy.builder().featureUriManager(featureUriManager).accessibleMethodsByUri(accessibleMethodsByUri).specialAdmin(EzyCollections.containsAny(roleIds, specialRoleIds)).superAdmin(roleIds.contains(superAdminRoleId)).build();
    }

    AdminRolesProxy(boolean superAdmin, boolean specialAdmin, FeatureURIManager featureUriManager, Map<String, Set<HttpMethod>> accessibleMethodsByUri) {
        this.superAdmin = superAdmin;
        this.specialAdmin = specialAdmin;
        this.featureUriManager = featureUriManager;
        this.accessibleMethodsByUri = accessibleMethodsByUri;
    }

    public static AdminRolesProxyBuilder builder() {
        return new AdminRolesProxyBuilder();
    }

    public boolean isSuperAdmin() {
        return this.superAdmin;
    }

    public boolean isSpecialAdmin() {
        return this.specialAdmin;
    }

    public static class AdminRolesProxyBuilder {
        private boolean superAdmin;
        private boolean specialAdmin;
        private FeatureURIManager featureUriManager;
        private Map<String, Set<HttpMethod>> accessibleMethodsByUri;

        AdminRolesProxyBuilder() {
        }

        public AdminRolesProxyBuilder superAdmin(boolean superAdmin) {
            this.superAdmin = superAdmin;
            return this;
        }

        public AdminRolesProxyBuilder specialAdmin(boolean specialAdmin) {
            this.specialAdmin = specialAdmin;
            return this;
        }

        public AdminRolesProxyBuilder featureUriManager(FeatureURIManager featureUriManager) {
            this.featureUriManager = featureUriManager;
            return this;
        }

        public AdminRolesProxyBuilder accessibleMethodsByUri(Map<String, Set<HttpMethod>> accessibleMethodsByUri) {
            this.accessibleMethodsByUri = accessibleMethodsByUri;
            return this;
        }

        public AdminRolesProxy build() {
            return new AdminRolesProxy(this.superAdmin, this.specialAdmin, this.featureUriManager, this.accessibleMethodsByUri);
        }

        public String toString() {
            return "AdminRolesProxy.AdminRolesProxyBuilder(superAdmin=" + this.superAdmin + ", specialAdmin=" + this.specialAdmin + ", featureUriManager=" + this.featureUriManager + ", accessibleMethodsByUri=" + this.accessibleMethodsByUri + ")";
        }
    }
}

