/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.model;

import com.tvd12.ezyfox.io.EzyLists;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;

public class PaginationModel<T> {
    private List<T> items;
    private PageToken pageToken;
    private Continuation continuation;
    private int count;
    private long total;
    private long timestamp;
    public static final PaginationModel EMPTY_PAGINATION = PaginationModel.builder().pageToken(PageToken.builder().build()).continuation(Continuation.builder().build()).items(Collections.emptyList()).build();

    public static <T> PaginationModel<T> emptyPagination() {
        return EMPTY_PAGINATION;
    }

    public <R> PaginationModel<R> map(Function<T, R> mapper) {
        return PaginationModel.builder().items(EzyLists.newArrayList(this.items, mapper)).pageToken(this.pageToken).continuation(this.continuation).count(this.count).total(this.total).timestamp(this.timestamp).build();
    }

    PaginationModel(List<T> items, PageToken pageToken, Continuation continuation, int count, long total, long timestamp) {
        this.items = items;
        this.pageToken = pageToken;
        this.continuation = continuation;
        this.count = count;
        this.total = total;
        this.timestamp = timestamp;
    }

    public static <T> PaginationModelBuilder<T> builder() {
        return new PaginationModelBuilder();
    }

    public List<T> getItems() {
        return this.items;
    }

    public PageToken getPageToken() {
        return this.pageToken;
    }

    public Continuation getContinuation() {
        return this.continuation;
    }

    public int getCount() {
        return this.count;
    }

    public long getTotal() {
        return this.total;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        return "PaginationModel(items=" + this.getItems() + ", pageToken=" + this.getPageToken() + ", continuation=" + this.getContinuation() + ", count=" + this.getCount() + ", total=" + this.getTotal() + ", timestamp=" + this.getTimestamp() + ")";
    }

    public static class PaginationModelBuilder<T> {
        private List<T> items;
        private PageToken pageToken;
        private Continuation continuation;
        private int count;
        private long total;
        private long timestamp;

        PaginationModelBuilder() {
        }

        public PaginationModelBuilder<T> items(List<T> items) {
            this.items = items;
            return this;
        }

        public PaginationModelBuilder<T> pageToken(PageToken pageToken) {
            this.pageToken = pageToken;
            return this;
        }

        public PaginationModelBuilder<T> continuation(Continuation continuation) {
            this.continuation = continuation;
            return this;
        }

        public PaginationModelBuilder<T> count(int count) {
            this.count = count;
            return this;
        }

        public PaginationModelBuilder<T> total(long total) {
            this.total = total;
            return this;
        }

        public PaginationModelBuilder<T> timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public PaginationModel<T> build() {
            return new PaginationModel<T>(this.items, this.pageToken, this.continuation, this.count, this.total, this.timestamp);
        }

        public String toString() {
            return "PaginationModel.PaginationModelBuilder(items=" + this.items + ", pageToken=" + this.pageToken + ", continuation=" + this.continuation + ", count=" + this.count + ", total=" + this.total + ", timestamp=" + this.timestamp + ")";
        }
    }

    public static class Continuation {
        private boolean hasNext;
        private boolean hasPrevious;

        Continuation(boolean hasNext, boolean hasPrevious) {
            this.hasNext = hasNext;
            this.hasPrevious = hasPrevious;
        }

        public static ContinuationBuilder builder() {
            return new ContinuationBuilder();
        }

        public boolean isHasNext() {
            return this.hasNext;
        }

        public boolean isHasPrevious() {
            return this.hasPrevious;
        }

        public String toString() {
            return "PaginationModel.Continuation(hasNext=" + this.isHasNext() + ", hasPrevious=" + this.isHasPrevious() + ")";
        }

        public static class ContinuationBuilder {
            private boolean hasNext;
            private boolean hasPrevious;

            ContinuationBuilder() {
            }

            public ContinuationBuilder hasNext(boolean hasNext) {
                this.hasNext = hasNext;
                return this;
            }

            public ContinuationBuilder hasPrevious(boolean hasPrevious) {
                this.hasPrevious = hasPrevious;
                return this;
            }

            public Continuation build() {
                return new Continuation(this.hasNext, this.hasPrevious);
            }

            public String toString() {
                return "PaginationModel.Continuation.ContinuationBuilder(hasNext=" + this.hasNext + ", hasPrevious=" + this.hasPrevious + ")";
            }
        }
    }

    public static class PageToken {
        private String next;
        private String prev;

        PageToken(String next, String prev) {
            this.next = next;
            this.prev = prev;
        }

        public static PageTokenBuilder builder() {
            return new PageTokenBuilder();
        }

        public String getNext() {
            return this.next;
        }

        public String getPrev() {
            return this.prev;
        }

        public String toString() {
            return "PaginationModel.PageToken(next=" + this.getNext() + ", prev=" + this.getPrev() + ")";
        }

        public static class PageTokenBuilder {
            private String next;
            private String prev;

            PageTokenBuilder() {
            }

            public PageTokenBuilder next(String next) {
                this.next = next;
                return this;
            }

            public PageTokenBuilder prev(String prev) {
                this.prev = prev;
                return this;
            }

            public PageToken build() {
                return new PageToken(this.next, this.prev);
            }

            public String toString() {
                return "PaginationModel.PageToken.PageTokenBuilder(next=" + this.next + ", prev=" + this.prev + ")";
            }
        }
    }
}

