/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.pagination;

import java.time.LocalDateTime;
import java.util.function.Supplier;
import org.youngmonkeys.ezyplatform.constant.CommonConstants;

public class LastUpdatedAtPageToken {
    private LocalDateTime updatedAt;
    private long idNumber;
    private String idText;
    private int offset;
    private int limit;
    private boolean fetchGreaterThanOrEquals;
    public static final int DEFAULT_LIMIT = 100;

    public LastUpdatedAtPageToken(LocalDateTime updatedAt, int offset, int limit, boolean fetchGreaterThanOrEquals) {
        this.updatedAt = updatedAt;
        this.offset = offset;
        this.limit = limit;
        this.fetchGreaterThanOrEquals = fetchGreaterThanOrEquals;
    }

    public LastUpdatedAtPageToken newLastPageToken(int itemCount, Supplier<LocalDateTime> lastUpdatedAtSupplier, Supplier<Object> lastIdSupplier) {
        long newLastIdNumber = this.idNumber;
        String newLastIdText = this.idText;
        LocalDateTime newLastUpdatedAt = this.updatedAt;
        if (itemCount > 0) {
            newLastUpdatedAt = lastUpdatedAtSupplier.get();
            Object newLastId = lastIdSupplier.get();
            if (newLastId != null) {
                if (newLastId instanceof Number) {
                    newLastIdNumber = ((Number)newLastId).longValue();
                } else {
                    newLastIdText = String.valueOf(newLastId);
                }
            }
        }
        return new LastUpdatedAtPageToken(newLastUpdatedAt, newLastIdNumber, newLastIdText, this.offset, this.limit, Boolean.TRUE);
    }

    public static LastUpdatedAtPageToken defaultPageToken() {
        return LastUpdatedAtPageToken.defaultPageToken(CommonConstants.MIN_SQL_DATETIME);
    }

    public static LastUpdatedAtPageToken defaultPageToken(LocalDateTime updatedAt) {
        return new LastUpdatedAtPageToken(updatedAt, 0, 100, true);
    }

    public LocalDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public long getIdNumber() {
        return this.idNumber;
    }

    public String getIdText() {
        return this.idText;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLimit() {
        return this.limit;
    }

    public boolean isFetchGreaterThanOrEquals() {
        return this.fetchGreaterThanOrEquals;
    }

    public void setUpdatedAt(LocalDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public void setIdNumber(long idNumber) {
        this.idNumber = idNumber;
    }

    public void setIdText(String idText) {
        this.idText = idText;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public void setFetchGreaterThanOrEquals(boolean fetchGreaterThanOrEquals) {
        this.fetchGreaterThanOrEquals = fetchGreaterThanOrEquals;
    }

    public LastUpdatedAtPageToken(LocalDateTime updatedAt, long idNumber, String idText, int offset, int limit, boolean fetchGreaterThanOrEquals) {
        this.updatedAt = updatedAt;
        this.idNumber = idNumber;
        this.idText = idText;
        this.offset = offset;
        this.limit = limit;
        this.fetchGreaterThanOrEquals = fetchGreaterThanOrEquals;
    }

    public LastUpdatedAtPageToken() {
    }
}

