/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.service;

import com.tvd12.ezyfox.io.EzyLists;
import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyfox.util.Next;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.youngmonkeys.ezyplatform.converter.DefaultEntityToModelConverter;
import org.youngmonkeys.ezyplatform.converter.DefaultModelToEntityConverter;
import org.youngmonkeys.ezyplatform.converter.DefaultResultToModelConverter;
import org.youngmonkeys.ezyplatform.data.TitleContent;
import org.youngmonkeys.ezyplatform.entity.ContentTemplate;
import org.youngmonkeys.ezyplatform.exception.ResourceNotFoundException;
import org.youngmonkeys.ezyplatform.model.ContentTemplateModel;
import org.youngmonkeys.ezyplatform.model.SaveContentTemplateModel;
import org.youngmonkeys.ezyplatform.repo.ContentTemplateRepository;
import org.youngmonkeys.ezyplatform.result.ContentTypeResult;
import org.youngmonkeys.ezyplatform.result.TemplateTypeResult;
import org.youngmonkeys.ezyplatform.service.ContentTemplateService;

public class DefaultContentTemplateService
implements ContentTemplateService {
    private final ContentTemplateRepository contentTemplateRepository;
    private final DefaultEntityToModelConverter entityToModelConverter;
    private final DefaultModelToEntityConverter modelToEntityConverter;
    private final DefaultResultToModelConverter resultToModelConverter;

    @Override
    public long addTemplate(String creatorType, long creatorId, SaveContentTemplateModel model) {
        ContentTemplate entity = this.modelToEntityConverter.toEntity(creatorType, creatorId, model);
        this.contentTemplateRepository.save(entity);
        return entity.getId();
    }

    @Override
    public void updateTemplate(long templateId, SaveContentTemplateModel model) {
        ContentTemplate entity = this.getContentTemplateEntityByIdOrThrow(templateId);
        this.modelToEntityConverter.mergeToEntity(model, entity);
        this.contentTemplateRepository.save(entity);
    }

    @Override
    public long saveTemplate(String creatorType, long creatorId, SaveContentTemplateModel model) {
        ContentTemplate entity = this.contentTemplateRepository.findByOwnerTypeAndOwnerIdAndTemplateTypeAndTemplateName(model.getOwnerType(), model.getOwnerId(), model.getTemplateType(), model.getTemplateName());
        if (entity == null) {
            entity = this.modelToEntityConverter.toEntity(creatorType, creatorId, model);
        } else {
            this.modelToEntityConverter.mergeToEntity(model, entity);
        }
        this.contentTemplateRepository.save(entity);
        return entity.getId();
    }

    @Override
    public void deleteTemplate(long templateId) {
        this.contentTemplateRepository.delete(templateId);
    }

    @Override
    public ContentTemplateModel getTemplateById(long templateId) {
        return this.entityToModelConverter.toModel((ContentTemplate)this.contentTemplateRepository.findById(templateId));
    }

    @Override
    public ContentTemplateModel getTemplateByTypeAndName(String templateType, String templateName) {
        return this.entityToModelConverter.toModel(this.contentTemplateRepository.findByTemplateTypeAndTemplateName(templateType, templateName));
    }

    @Override
    public List<ContentTemplateModel> getTemplatesByType(String templateType, int limit) {
        return EzyLists.newArrayList(this.contentTemplateRepository.findTemplatesByType(templateType, Next.limit((long)limit)), this.resultToModelConverter::toModel);
    }

    @Override
    public List<String> getAllTemplateTypes() {
        return EzyLists.newArrayList(this.contentTemplateRepository.findAllTemplateTypes(), TemplateTypeResult::getTemplateType);
    }

    @Override
    public List<String> getAllTemplateContentTypes() {
        return this.contentTemplateRepository.findAllContentTypes().stream().map(ContentTypeResult::getContentType).filter(EzyStrings::isNotBlank).collect(Collectors.toList());
    }

    @Override
    public boolean containsTemplateByTypeAndName(String templateType, String templateName) {
        return this.contentTemplateRepository.countByTemplateTypeAndTemplateName(templateType, templateName) > 0;
    }

    @Override
    public TitleContent makeTitleContent(String templateType, String templateName, Map<String, Object> parameters) {
        ContentTemplateModel template = this.getTemplateByTypeAndName(templateType, templateName);
        return TitleContent.fromTemplates(template.getTitleTemplate(), template.getContentTemplate(), parameters);
    }

    @Override
    public long countTemplatesByType(String templateType) {
        return this.contentTemplateRepository.countByTemplateType(templateType);
    }

    protected ContentTemplate getContentTemplateEntityByIdOrThrow(long contentTemplateId) {
        ContentTemplate entity = (ContentTemplate)this.contentTemplateRepository.findById(contentTemplateId);
        if (entity == null) {
            throw new ResourceNotFoundException("contentTemplate");
        }
        return entity;
    }

    public DefaultContentTemplateService(ContentTemplateRepository contentTemplateRepository, DefaultEntityToModelConverter entityToModelConverter, DefaultModelToEntityConverter modelToEntityConverter, DefaultResultToModelConverter resultToModelConverter) {
        this.contentTemplateRepository = contentTemplateRepository;
        this.entityToModelConverter = entityToModelConverter;
        this.modelToEntityConverter = modelToEntityConverter;
        this.resultToModelConverter = resultToModelConverter;
    }
}

