/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.service;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.youngmonkeys.ezyplatform.converter.DefaultEntityToModelConverter;
import org.youngmonkeys.ezyplatform.converter.DefaultModelToEntityConverter;
import org.youngmonkeys.ezyplatform.entity.Letter;
import org.youngmonkeys.ezyplatform.entity.LetterReceiver;
import org.youngmonkeys.ezyplatform.model.AddLetterModel;
import org.youngmonkeys.ezyplatform.model.AddLetterReceiverModel;
import org.youngmonkeys.ezyplatform.model.SimpleLetterModel;
import org.youngmonkeys.ezyplatform.repo.LetterReceiverRepository;
import org.youngmonkeys.ezyplatform.repo.LetterRepository;
import org.youngmonkeys.ezyplatform.service.LetterService;

public class DefaultLetterService
implements LetterService {
    private final LetterRepository letterRepository;
    private final LetterReceiverRepository letterReceiverRepository;
    private final DefaultEntityToModelConverter entityToModelConverter;
    private final DefaultModelToEntityConverter modelToEntityConverter;

    @Override
    public long addLetter(AddLetterModel model) {
        Letter letter = this.modelToEntityConverter.toEntity(model);
        this.letterRepository.save(letter);
        List<LetterReceiver> letterReceivers = this.modelToEntityConverter.toEntities(letter.getId(), model);
        if (!letterReceivers.isEmpty()) {
            this.letterReceiverRepository.save(letterReceivers);
        }
        return letter.getId();
    }

    @Override
    public long addLetterReceiver(AddLetterReceiverModel model) {
        LetterReceiver entity = this.modelToEntityConverter.toEntity(model);
        this.letterReceiverRepository.save(entity);
        return entity.getId();
    }

    @Override
    public Map<Long, SimpleLetterModel> getLetterMapByIds(Collection<Long> letterIds) {
        if (letterIds.isEmpty()) {
            return Collections.emptyMap();
        }
        return this.letterRepository.findListByIds(letterIds).stream().collect(Collectors.toMap(Letter::getId, this.entityToModelConverter::toModel));
    }

    public DefaultLetterService(LetterRepository letterRepository, LetterReceiverRepository letterReceiverRepository, DefaultEntityToModelConverter entityToModelConverter, DefaultModelToEntityConverter modelToEntityConverter) {
        this.letterRepository = letterRepository;
        this.letterReceiverRepository = letterReceiverRepository;
        this.entityToModelConverter = entityToModelConverter;
        this.modelToEntityConverter = modelToEntityConverter;
    }
}

