/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.service;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.youngmonkeys.ezyplatform.converter.DefaultEntityToModelConverter;
import org.youngmonkeys.ezyplatform.converter.DefaultModelToEntityConverter;
import org.youngmonkeys.ezyplatform.entity.Notification;
import org.youngmonkeys.ezyplatform.entity.NotificationReceiver;
import org.youngmonkeys.ezyplatform.model.AddNotificationModel;
import org.youngmonkeys.ezyplatform.model.AddNotificationReceiverModel;
import org.youngmonkeys.ezyplatform.model.SimpleNotificationModel;
import org.youngmonkeys.ezyplatform.repo.NotificationReceiverRepository;
import org.youngmonkeys.ezyplatform.repo.NotificationRepository;
import org.youngmonkeys.ezyplatform.service.NotificationService;

public class DefaultNotificationService
implements NotificationService {
    private final NotificationRepository notificationRepository;
    private final NotificationReceiverRepository notificationReceiverRepository;
    private final DefaultEntityToModelConverter entityToModelConverter;
    private final DefaultModelToEntityConverter modelToEntityConverter;

    @Override
    public long addNotification(AddNotificationModel model) {
        Notification notification = this.modelToEntityConverter.toEntity(model);
        this.notificationRepository.save(notification);
        List<NotificationReceiver> notificationReceivers = this.modelToEntityConverter.toEntities(notification.getId(), model);
        if (!notificationReceivers.isEmpty()) {
            this.notificationReceiverRepository.save(notificationReceivers);
        }
        return notification.getId();
    }

    @Override
    public long addNotificationReceiver(AddNotificationReceiverModel model) {
        NotificationReceiver entity = this.modelToEntityConverter.toEntity(model);
        this.notificationReceiverRepository.save(entity);
        return entity.getId();
    }

    @Override
    public Map<Long, SimpleNotificationModel> getNotificationMapByIds(Collection<Long> notificationIds) {
        if (notificationIds.isEmpty()) {
            return Collections.emptyMap();
        }
        return this.notificationRepository.findListByIds(notificationIds).stream().collect(Collectors.toMap(Notification::getId, this.entityToModelConverter::toModel));
    }

    public DefaultNotificationService(NotificationRepository notificationRepository, NotificationReceiverRepository notificationReceiverRepository, DefaultEntityToModelConverter entityToModelConverter, DefaultModelToEntityConverter modelToEntityConverter) {
        this.notificationRepository = notificationRepository;
        this.notificationReceiverRepository = notificationReceiverRepository;
        this.entityToModelConverter = entityToModelConverter;
        this.modelToEntityConverter = modelToEntityConverter;
    }
}

