/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.service;

import com.tvd12.ezyfox.exception.EzyNotImplementedException;
import com.tvd12.ezyfox.function.EzyExceptionFunction;
import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyhttp.core.codec.SingletonStringDeserializer;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.youngmonkeys.ezyplatform.entity.DataType;
import org.youngmonkeys.ezyplatform.util.Randoms;
import org.youngmonkeys.ezyplatform.util.Uris;

public interface SettingService {
    public static final int DEFAULT_CACHE_PERIOD_IN_SECOND = 5;

    public void watchLastUpdatedTime(String var1, int var2, Runnable var3);

    default public void watchLastUpdatedTime(String settingName, Runnable onLastUpdatedTimeChange) {
        this.watchLastUpdatedTime(settingName, 5, onLastUpdatedTimeChange);
    }

    public void watchLastUpdatedTimeAndCache(String var1, int var2);

    default public void watchLastUpdatedTimeAndCache(String settingName) {
        this.watchLastUpdatedTimeAndCache(settingName, 5);
    }

    public void addValueConverter(String var1, EzyExceptionFunction<String, Object> var2);

    public void scheduleCacheValue(String var1, int var2);

    default public void scheduleCacheValue(String settingName) {
        this.scheduleCacheValue(settingName, 5);
    }

    default public void saveSetting(String name, DataType dataType, Object value) {
        throw new EzyNotImplementedException("saveSetting has not implemented yet");
    }

    public String getDecryptionValue(String var1);

    default public <T> T getCachedValue(String settingName) {
        return this.getCachedValue(settingName, null);
    }

    public <T> T getCachedValue(String var1, T var2);

    public Optional<String> getSettingValue(String var1);

    public long getMaxUploadFileSize();

    public Set<String> getAcceptedMediaMimeTypes();

    default public String encryptValue(String settingValue) {
        throw new EzyNotImplementedException("encryptValue has not implemented yet");
    }

    public String decryptValue(String var1);

    public <T> T getObjectValue(String var1, Class<T> var2);

    default public <T> T getObjectValue(String settingName, Class<T> objectType, T defaultValue) {
        T answer = this.getObjectValue(settingName, objectType);
        return answer != null ? answer : defaultValue;
    }

    default public <T> T getObjectValueOrDefault(String settingName, Class<T> objectType, Supplier<T> defaultValueSupplier) {
        T answer = this.getObjectValue(settingName, objectType);
        return answer != null ? answer : defaultValueSupplier.get();
    }

    default public String getPasswordValue(String settingName) {
        return this.getDecryptionValue(settingName);
    }

    default public boolean getBooleanValue(String settingName) {
        return this.getBooleanValue(settingName, false);
    }

    default public boolean getBooleanValue(String settingName, boolean defaultValue) {
        return this.getSettingValue(settingName).map(it -> {
            try {
                return Boolean.parseBoolean(it);
            }
            catch (Exception e) {
                return defaultValue;
            }
        }).orElse(defaultValue);
    }

    default public int getIntValue(String settingName) {
        return this.getIntValue(settingName, 0);
    }

    default public int getIntValue(String settingName, int defaultValue) {
        return (int)this.getLongValue(settingName, defaultValue);
    }

    default public long getLongValue(String settingName) {
        return this.getLongValue(settingName, 0L);
    }

    default public long getLongValue(String settingName, long defaultValue) {
        return this.getSettingValue(settingName).map(it -> {
            try {
                return Long.parseLong(it);
            }
            catch (Exception e) {
                return defaultValue;
            }
        }).orElse(defaultValue);
    }

    default public String getTextValue(String settingName) {
        return this.getTextValue(settingName, null);
    }

    default public String getTextValue(String settingName, String defaultValue) {
        return this.getSettingValue(settingName).orElse(defaultValue);
    }

    default public <T> T getArrayValue(String settingName, Class<T> arrayType) {
        String textValue = this.getTextValue(settingName);
        if (textValue == null) {
            return null;
        }
        try {
            return (T)SingletonStringDeserializer.getInstance().deserialize(textValue, arrayType);
        }
        catch (Exception e) {
            return null;
        }
    }

    default public Set<String> getSetStringValue(String settingName) {
        return this.getSetValue(settingName, String.class);
    }

    default public Set<String> getSetStringValue(String settingName, Set<String> defaultValue) {
        Set<String> value = this.getSetValue(settingName, String.class);
        return value.isEmpty() ? defaultValue : value;
    }

    default public <T> Set<T> getSetValue(String settingName, Class<T> valueType) {
        String textValue = this.getTextValue(settingName);
        if (textValue == null) {
            return Collections.emptySet();
        }
        try {
            return (Set)SingletonStringDeserializer.getInstance().deserialize(textValue, Set.class, valueType);
        }
        catch (Exception e) {
            return Collections.emptySet();
        }
    }

    default public List<String> getListStringValue(String settingName) {
        return this.getListValue(settingName, String.class);
    }

    default public List<String> getListStringValue(String settingName, List<String> defaultValue) {
        List<String> value = this.getListValue(settingName, String.class);
        return value.isEmpty() ? defaultValue : value;
    }

    default public <T> List<T> getListValue(String settingName, Class<T> valueType) {
        String textValue = this.getTextValue(settingName);
        if (textValue == null) {
            return Collections.emptyList();
        }
        try {
            return (List)SingletonStringDeserializer.getInstance().deserialize(textValue, List.class, valueType);
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    default public String getNodeName() {
        return this.getTextValue("ezyplatformNodeName");
    }

    default public int getPaginationCountLimit() {
        return this.getIntValue("ezyplatform_pagination_count_limit", 1000000);
    }

    default public String getWebSiteName() {
        String siteTitle = this.getTextValue("web_site_title");
        if (EzyStrings.isNotBlank((String)siteTitle)) {
            return siteTitle;
        }
        String webUrl = this.getWebUrl();
        if (EzyStrings.isNotBlank((String)webUrl)) {
            return Uris.getSiteName(webUrl);
        }
        String adminUrl = this.getAdminUrl();
        return Uris.getSiteName(adminUrl, "Website");
    }

    default public String getAdminDateFormat() {
        return this.getTextValue("admin_date_format", "YYYY-MM-DD");
    }

    default public String getAdminTimeFormat() {
        return this.getTextValue("admin_time_format", "HH:mm:ss");
    }

    default public String getAdminDateTimeFormat() {
        return this.getTextValue("admin_datetime_format", "YYYY-MM-DD HH:mm:ss");
    }

    default public String getAdminDateMinuteFormat() {
        return this.getTextValue("admin_date_minute_format", "YYYY-MM-DD HH:mm");
    }

    default public String getWebDateFormat() {
        return this.getTextValue("web_date_format", "YYYY-MM-DD");
    }

    default public String getWebTimeFormat() {
        return this.getTextValue("web_time_format", "HH:mm:ss");
    }

    default public String getWebDateTimeFormat() {
        return this.getTextValue("web_datetime_format", "YYYY-MM-DD HH:mm:ss");
    }

    default public String getWebDateMinuteFormat() {
        return this.getTextValue("web_date_minute_format", "YYYY-MM-DD HH:mm");
    }

    default public String getAdminUrl() {
        return this.getTextValue("admin_url", "http://localhost:9090");
    }

    default public String getWebUrl() {
        return this.getTextValue("web_url", "http://localhost:8080");
    }

    default public String getWebManagementUrl() {
        return this.getTextValue("web_management_url", "http://localhost:18080");
    }

    default public String getWebsocketUrl() {
        return this.getTextValue("websocket_url", "ws://localhost:2208/ws");
    }

    default public long getUserTokenExpiredTimeInDay() {
        return this.getLongValue("user_token_expired_in_day", 7L);
    }

    default public String getMediaUpDownloaderName() {
        return this.getTextValue("ezyplatform_media_up_down_loader_name");
    }

    default public boolean isAllowSendStatisticsData() {
        return this.getBooleanValue("allow_send_statistics_data", true);
    }

    default public boolean containSetting(String settingName) {
        return this.getSettingValue(settingName).isPresent();
    }

    default public String resolveAdminUri(String uri) {
        return Uris.resolveUrl(this.getAdminUrl(), uri);
    }

    default public String resolveWebUri(String uri) {
        return Uris.resolveUrl(this.getWebUrl(), uri);
    }

    default public String resolveWebManagementUri(String uri) {
        return Uris.resolveUrl(this.getWebManagementUrl(), uri);
    }

    default public String randomWebEmail() {
        return Randoms.randomEmailFromUrl(this.getWebUrl());
    }
}

