/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyhttp.core.codec;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.tvd12.ezyfox.util.EzyDestroyable;
import com.tvd12.ezyhttp.core.codec.BodyConverter;
import com.tvd12.ezyhttp.core.codec.BodyDeserializer;
import com.tvd12.ezyhttp.core.codec.BodySerializer;
import com.tvd12.ezyhttp.core.codec.DefaultStringDeserializer;
import com.tvd12.ezyhttp.core.codec.FormBodyConverter;
import com.tvd12.ezyhttp.core.codec.JsonBodyConverter;
import com.tvd12.ezyhttp.core.codec.StringDeserializer;
import com.tvd12.ezyhttp.core.codec.TextBodyConverter;
import com.tvd12.ezyhttp.core.constant.ContentTypes;
import com.tvd12.ezyhttp.core.util.BodyConvertAnnotations;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DataConverters
implements EzyDestroyable {
    protected StringDeserializer stringDeserializer;
    protected final BodyConverter defaultBodyConverter;
    protected final Map<String, BodySerializer> bodySerializers = new HashMap<String, BodySerializer>();
    protected final Map<String, BodyDeserializer> bodyDeserializers = new HashMap<String, BodyDeserializer>();

    public DataConverters(ObjectMapper objectMapper) {
        this.defaultBodyConverter = new TextBodyConverter();
        this.addDefaultConverter(objectMapper);
    }

    public BodySerializer getBodySerializer(String contentType) {
        BodySerializer serializer = this.bodySerializers.get(contentType);
        if (serializer == null) {
            String realContentType = ContentTypes.getContentType(contentType);
            serializer = this.bodySerializers.get(realContentType);
        }
        if (serializer == null) {
            serializer = this.defaultBodyConverter;
        }
        return serializer;
    }

    public BodyDeserializer getBodyDeserializer(String contentType) {
        BodyDeserializer deserializer = this.bodyDeserializers.get(contentType);
        if (deserializer == null) {
            String realContentType = ContentTypes.getContentType(contentType);
            deserializer = this.bodyDeserializers.get(realContentType);
        }
        if (deserializer == null) {
            deserializer = this.defaultBodyConverter;
        }
        return deserializer;
    }

    public void addBodyConverters(List<?> converters) {
        for (Object converter : converters) {
            this.addBodyConverter(converter);
        }
    }

    public void addBodyConverters(Map<String, Object> converterByContentType) {
        for (Map.Entry<String, Object> e : converterByContentType.entrySet()) {
            this.addBodyConverter(e.getKey(), e.getValue());
        }
    }

    public void addBodyConverter(Object converter) {
        String contentType;
        if (converter instanceof BodySerializer) {
            contentType = BodyConvertAnnotations.getContentType(converter);
            this.bodySerializers.put(contentType, (BodySerializer)converter);
        }
        if (converter instanceof BodyDeserializer) {
            contentType = BodyConvertAnnotations.getContentType(converter);
            this.bodyDeserializers.put(contentType, (BodyDeserializer)converter);
        }
    }

    public void addBodyConverter(String contentType, Object converter) {
        if (converter instanceof BodySerializer) {
            this.bodySerializers.put(contentType, (BodySerializer)converter);
        }
        if (converter instanceof BodyDeserializer) {
            this.bodyDeserializers.put(contentType, (BodyDeserializer)converter);
        }
    }

    public void setStringConverter(Object converter) {
        if (converter instanceof StringDeserializer) {
            this.stringDeserializer = (StringDeserializer)converter;
        }
    }

    public void setStringConverters(List<?> converters) {
        for (Object converter : converters) {
            this.setStringConverter(converter);
        }
    }

    protected void addDefaultConverter(ObjectMapper objectMapper) {
        JsonBodyConverter jsonBodyConverter = new JsonBodyConverter(objectMapper);
        FormBodyConverter formBodyConverter = new FormBodyConverter(objectMapper);
        this.bodySerializers.put("application/json", jsonBodyConverter);
        this.bodySerializers.put("application/x-www-form-urlencoded", formBodyConverter);
        this.bodySerializers.put("text/plain", this.defaultBodyConverter);
        this.bodyDeserializers.put("application/json", jsonBodyConverter);
        this.bodyDeserializers.put("application/x-www-form-urlencoded", formBodyConverter);
        this.bodyDeserializers.put("multipart/form-data", formBodyConverter);
        this.stringDeserializer = new DefaultStringDeserializer();
        this.bodyDeserializers.put("text/plain", this.defaultBodyConverter);
        this.bodyDeserializers.put("text/html", this.defaultBodyConverter);
        this.bodyDeserializers.put("text/html; charset=utf-8", this.defaultBodyConverter);
    }

    public void destroy() {
        this.bodySerializers.clear();
        this.bodyDeserializers.clear();
    }

    public StringDeserializer getStringDeserializer() {
        return this.stringDeserializer;
    }
}

