/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.cli.handler;

import com.tvd12.ezyfox.io.EzyStrings;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.youngmonkeys.ezyplatform.cli.Command;
import org.youngmonkeys.ezyplatform.cli.arguments.ActModuleArguments;
import org.youngmonkeys.ezyplatform.cli.arguments.Arguments;
import org.youngmonkeys.ezyplatform.cli.constant.CliConstants;
import org.youngmonkeys.ezyplatform.cli.data.ModuleMetadata;
import org.youngmonkeys.ezyplatform.cli.handler.AbstractCommandHandler;
import org.youngmonkeys.ezyplatform.cli.io.CliFolderProxy;
import org.youngmonkeys.ezyplatform.cli.io.CliModuleMetadataMapReader;
import org.youngmonkeys.ezyplatform.cli.util.FileUtil;

public abstract class ActModuleCommandHandler
extends AbstractCommandHandler<ActModuleArguments> {
    private final Command actCommand = this.getActCommand();

    @Override
    public final void handle(ActModuleArguments args) throws Exception {
        Map<String, ModuleMetadata> moduleMetadataByName;
        List<String> moduleTypes = args.getModuleTypes();
        Map<String, List<String>> moduleNamesByModuleType = CliFolderProxy.getModuleNamesMapByModuleTypes(moduleTypes);
        Map<String, Map<String, ModuleMetadata>> moduleMetadataByNameByModuleType = CliModuleMetadataMapReader.getInstance().readByModuleTypes(moduleTypes);
        String moduleName = args.getModuleName();
        boolean applyToAllModule = EzyStrings.isBlank((String)moduleName);
        boolean active = this.actCommand == Command.ACTIVATE;
        HashMap<String, List<String>> updatedModuleNamesByModuleType = new HashMap<String, List<String>>();
        for (String moduleType : moduleTypes) {
            moduleMetadataByName = moduleMetadataByNameByModuleType.get(moduleType);
            if (applyToAllModule) {
                List<String> moduleNames = moduleNamesByModuleType.get(moduleType);
                moduleMetadataByName = moduleNames.stream().collect(Collectors.toMap(it -> it, it -> new ModuleMetadata((String)it, active)));
                updatedModuleNamesByModuleType.put(moduleType, moduleNames);
            } else {
                moduleMetadataByName.put(moduleName, new ModuleMetadata(moduleName, active));
                updatedModuleNamesByModuleType.put(moduleType, Collections.singletonList(moduleName));
            }
            moduleMetadataByNameByModuleType.put(moduleType, moduleMetadataByName);
        }
        this.handle(moduleTypes, moduleMetadataByNameByModuleType, updatedModuleNamesByModuleType, args.isVerbose());
        for (String moduleType : moduleTypes) {
            moduleMetadataByName = moduleMetadataByNameByModuleType.get(moduleType);
            if (moduleMetadataByName == null) continue;
            File moduleMetadataFile = CliFolderProxy.getModuleMetadataFileByModuleType(moduleType);
            FileUtil.createFile(moduleMetadataFile);
            this.objectMapper.writeValue(moduleMetadataFile, moduleMetadataByName.values());
        }
        System.out.println((EzyStrings.isBlank((String)moduleName) ? "" : moduleName + " ") + "(" + args.getModuleType() + ") is " + this.resultString());
    }

    protected void handle(List<String> moduleTypes, Map<String, Map<String, ModuleMetadata>> moduleMetadataByNameByModuleType, Map<String, List<String>> updatedModuleNamesByModuleType, boolean verbose) throws Exception {
    }

    protected String resultString() {
        return "activated";
    }

    @Override
    public Arguments parse(String string) {
        String moduleName;
        String[] strs = string.split(" ");
        if (strs.length < this.getMaxArgumentCount()) {
            String command = this.actCommand.getName();
            throw new IllegalArgumentException("Usage: \"" + command + " all|" + String.join((CharSequence)"|", CliConstants.MODULE_TYPES) + " " + this.getModuleNameParam() + "\"");
        }
        String moduleType = strs[0].trim();
        if (!moduleType.equals("all") && !CliConstants.MODULE_TYPES.contains(moduleType)) {
            throw new IllegalArgumentException("Module type must be in all|" + String.join((CharSequence)"|", CliConstants.MODULE_TYPES));
        }
        String string2 = moduleName = strs.length == 1 ? "" : strs[1].trim();
        if (EzyStrings.isBlank((String)moduleName) && this.requiredModuleName()) {
            throw new IllegalArgumentException("Module name is required");
        }
        if (!moduleType.equals("all") && !CliFolderProxy.containsModule(moduleType, moduleName)) {
            throw new IllegalArgumentException("Module: " + moduleName + " not found");
        }
        boolean verbose = strs.length >= 3 && strs[2].trim().equals("-v");
        return new ActModuleArguments(moduleType, moduleName, verbose);
    }

    protected abstract int getMaxArgumentCount();

    protected abstract Command getActCommand();

    protected abstract String getModuleNameParam();

    protected abstract boolean requiredModuleName();
}

