/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.devtools.swagger;

import com.tvd12.ezyfox.annotation.EzyFeature;
import com.tvd12.ezyfox.file.EzySimpleFileWriter;
import com.tvd12.ezyfox.io.EzyLists;
import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyfox.reflect.EzyGenerics;
import com.tvd12.ezyfox.reflect.EzyMethods;
import com.tvd12.ezyfox.reflect.EzyReflectionProxy;
import com.tvd12.ezyfox.reflect.EzyTypes;
import com.tvd12.ezyfox.stream.EzyAnywayInputStreamLoader;
import com.tvd12.ezyfox.stream.EzyInputStreams;
import com.tvd12.ezyfox.util.EzyFileUtil;
import com.tvd12.ezyfox.util.EzyMapBuilder;
import com.tvd12.ezyhttp.core.response.ResponseEntity;
import com.tvd12.ezyhttp.server.core.annotation.Api;
import com.tvd12.ezyhttp.server.core.annotation.Authenticated;
import com.tvd12.ezyhttp.server.core.annotation.Controller;
import com.tvd12.ezyhttp.server.core.annotation.DoDelete;
import com.tvd12.ezyhttp.server.core.annotation.DoGet;
import com.tvd12.ezyhttp.server.core.annotation.DoPost;
import com.tvd12.ezyhttp.server.core.annotation.DoPut;
import com.tvd12.ezyhttp.server.core.annotation.PathVariable;
import com.tvd12.ezyhttp.server.core.annotation.RequestBody;
import com.tvd12.ezyhttp.server.core.annotation.RequestParam;
import com.tvd12.ezyhttp.server.core.view.Redirect;
import com.tvd12.ezyhttp.server.core.view.View;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class SwaggerGenerator {
    private final String packageToScan;
    private static final Class<?> NO_GENERICS_TYPE = null;
    private static final Map<String, String> SWAGGER_TYPE_BY_JAVA_TYPE_NAME = EzyMapBuilder.mapBuilder().put((Object)"float", (Object)"number").put((Object)"double", (Object)"number").put((Object)"long", (Object)"number").toMap();
    private static final Map<String, String> SWAGGER_FORMAT_BY_JAVA_TYPE_NAME = EzyMapBuilder.mapBuilder().put((Object)"float", (Object)"float").put((Object)"double", (Object)"number").put((Object)"integer", (Object)"int32").put((Object)"long", (Object)"int64").toMap();

    public void generateToDefaultFile() throws IOException {
        this.generateToFile("swagger.yaml");
    }

    public void generateToFile(String filePath) throws IOException {
        File file = new File(filePath);
        EzyFileUtil.createFileIfNotExists((File)file);
        new EzySimpleFileWriter().write(file, (CharSequence)this.generate(), StandardCharsets.UTF_8.toString());
        System.out.println("generated to: " + filePath);
    }

    public String generate() throws IOException {
        SwaggerTemplate swaggerTemplate = new SwaggerTemplate();
        String servers = swaggerTemplate.createContent("server", EzyMapBuilder.mapBuilder().put((Object)"url", (Object)"http://localhost:8080").put((Object)"description", (Object)"localhost").toMap(), 1);
        EzyReflectionProxy reflection = new EzyReflectionProxy(this.packageToScan);
        Set controllerClasses = reflection.getAnnotatedClasses(Controller.class);
        List apiClasses = EzyLists.newArrayList((Collection)controllerClasses, this::extractControllerClass);
        HashSet<ApiMethod> generatedMethods = new HashSet<ApiMethod>();
        ArrayList<String> apis = new ArrayList<String>();
        for (ApiClass apiClass : apiClasses) {
            for (String uri : apiClass.methodsByUri.keySet()) {
                List apiMethods = EzyLists.filter((Collection)((Collection)apiClass.methodsByUri.get(uri)), it -> !generatedMethods.contains(it));
                for (int i = 0; i < apiMethods.size(); ++i) {
                    ApiMethod apiMethod = (ApiMethod)apiMethods.get(i);
                    generatedMethods.add(apiMethod);
                    apis.add(swaggerTemplate.createContent("api", EzyMapBuilder.mapBuilder().put((Object)"uri", (Object)(i == 0 ? uri : "")).put((Object)"method", (Object)apiMethod.type).put((Object)"summary", (Object)this.toFriendlyText(apiMethod.name)).put((Object)"description", (Object)this.createApiDescription(apiMethod)).put((Object)"parameters", (Object)this.createApiParameters(apiMethod.parameters, swaggerTemplate)).put((Object)"request_body", (Object)this.createApiRequestBody(apiMethod, swaggerTemplate)).put((Object)"responses", (Object)this.createApiResponseBody(apiMethod, swaggerTemplate)).toMap(), 1));
                }
            }
        }
        return swaggerTemplate.createContent("file", EzyMapBuilder.mapBuilder().put((Object)"open_api_version", (Object)"3.0.2").put((Object)"title", (Object)"APIs").put((Object)"version", (Object)"1.0.0").put((Object)"servers", (Object)servers).put((Object)"apis", (Object)this.joinString(apis, 1)).toMap(), 0);
    }

    private String createApiDescription(ApiMethod apiMethod) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("- feature: " + this.toFriendlyText(apiMethod.feature));
        lines.add("- api: " + (apiMethod.api ? "yes" : "no"));
        lines.add("- authenticated: " + (apiMethod.authenticated ? "yes" : "no"));
        return this.joinString(lines, 4);
    }

    private String createApiParameters(List<ApiParameter> apiParameters, SwaggerTemplate swaggerTemplate) {
        if (apiParameters.isEmpty()) {
            return "";
        }
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("parameters:");
        lines.addAll(apiParameters.stream().map(it -> this.createApiParameter((ApiParameter)it, swaggerTemplate)).collect(Collectors.toList()));
        return this.joinString(lines, 4);
    }

    private String createApiParameter(ApiParameter apiParameter, SwaggerTemplate swaggerTemplate) {
        String javaType = this.mapJavaType(apiParameter.javaType);
        String swaggerType = SWAGGER_TYPE_BY_JAVA_TYPE_NAME.getOrDefault(javaType, javaType);
        String swaggerFormat = SWAGGER_FORMAT_BY_JAVA_TYPE_NAME.get(javaType);
        String properties = "";
        if ("array".equals(javaType)) {
            String javaGenericsType = "object";
            Class genericsType = apiParameter.javaGenericsType;
            if (genericsType != null) {
                javaGenericsType = this.mapJavaType(genericsType);
            }
            String swaggerGenericsType = SWAGGER_TYPE_BY_JAVA_TYPE_NAME.getOrDefault(javaGenericsType, javaGenericsType);
            String swaggerGenericsFormat = SWAGGER_FORMAT_BY_JAVA_TYPE_NAME.get(javaGenericsType);
            properties = swaggerTemplate.createContent("response array data", EzyMapBuilder.mapBuilder().put((Object)"type", (Object)swaggerGenericsType).put((Object)"format", (Object)(swaggerGenericsFormat != null ? "format: " + swaggerGenericsFormat : "")).put((Object)"properties", (Object)("array".equals(swaggerGenericsType) ? swaggerTemplate.createContent("response array data", EzyMapBuilder.mapBuilder().put((Object)"type", (Object)"object").put((Object)"format", (Object)"").put((Object)"properties", (Object)"").toMap(), 7) : "")).toMap(), 6);
        }
        return swaggerTemplate.createContent("parameter", EzyMapBuilder.mapBuilder().put((Object)"name", (Object)apiParameter.name).put((Object)"in", (Object)apiParameter.in).put((Object)"type", (Object)swaggerType).put((Object)"format", (Object)(swaggerFormat != null ? "format: " + swaggerFormat : "")).put((Object)"properties", (Object)properties).put((Object)"description", (Object)(apiParameter.defaultValue != null ? "default value is " + apiParameter.defaultValue : "parameter")).put((Object)"required", (Object)"path".equals(apiParameter.in)).toMap(), 4);
    }

    private String createApiRequestBody(ApiMethod apiMethod, SwaggerTemplate swaggerTemplate) {
        if (apiMethod.requestBody == null) {
            return "";
        }
        return swaggerTemplate.createContent("request body", EzyMapBuilder.mapBuilder().put((Object)"content_type", (Object)"application/json").put((Object)"required", (Object)"true").put((Object)"type", (Object)"object").put((Object)"format", (Object)"").put((Object)"properties", (Object)this.createProperties(apiMethod.requestBody.fields, SwaggerGenerator.NO_GENERICS_TYPE, 8, "set")).toMap(), 3);
    }

    private String createApiResponseBody(ApiMethod apiMethod, SwaggerTemplate swaggerTemplate) {
        String responseContent;
        if (apiMethod.response.fields == null) {
            responseContent = "";
        } else {
            String responseData;
            String type;
            String string = type = Collection.class.isAssignableFrom(apiMethod.response.type) ? "array" : "object";
            if ("object".equals(type)) {
                responseData = this.createProperties(apiMethod.response.fields, apiMethod.response.genericsType, 9, "get");
            } else {
                String javaGenericsType = this.mapJavaType(apiMethod.response.genericsType);
                String swaggerGenericsType = SWAGGER_TYPE_BY_JAVA_TYPE_NAME.getOrDefault(javaGenericsType, javaGenericsType);
                String swaggerGenericsFormat = SWAGGER_FORMAT_BY_JAVA_TYPE_NAME.get(swaggerGenericsType);
                EzyMapBuilder parameters = EzyMapBuilder.mapBuilder().put((Object)"type", (Object)swaggerGenericsType).put((Object)"format", (Object)(swaggerGenericsFormat != null ? "format: " + swaggerGenericsFormat : ""));
                if ("object".equals(javaGenericsType)) {
                    parameters.put((Object)"properties", (Object)this.createProperties(this.extractApiDataFields(apiMethod.response.genericsType, "get"), apiMethod.response.genericsType, 10, "get"));
                } else if ("array".equals(javaGenericsType)) {
                    parameters.put((Object)"properties", (Object)swaggerTemplate.createContent("response array data", EzyMapBuilder.mapBuilder().put((Object)"type", (Object)"object").put((Object)"format", (Object)"").put((Object)"properties", (Object)"").toMap(), 9));
                }
                responseData = swaggerTemplate.createContent("response array data", parameters.toMap(), 8);
            }
            responseContent = swaggerTemplate.createContent("response content", EzyMapBuilder.mapBuilder().put((Object)"content_type", (Object)"application/json").put((Object)"type", (Object)type).put((Object)"format", (Object)"").put((Object)"response_data", (Object)responseData).toMap(), 6);
        }
        String code = "200";
        String description = "success";
        if (apiMethod.response.type == Redirect.class) {
            code = "302";
            description = "redirect";
        } else if (apiMethod.response.type == ResponseEntity.class) {
            code = "204";
            description = "no content";
        } else if (apiMethod.response.type == View.class) {
            description = "return a view";
        }
        return swaggerTemplate.createContent("response", EzyMapBuilder.mapBuilder().put((Object)"code", (Object)code).put((Object)"description", (Object)description).put((Object)"content", (Object)responseContent).toMap(), 4);
    }

    private String createProperties(List<ApiDataField> fields, Class<?> parentGenericTypes, int doubleSpaces, String methodPrefix) {
        if (fields.isEmpty()) {
            return "";
        }
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("properties:");
        for (ApiDataField field : fields) {
            lines.add(field.name + ":");
            String javaType = this.mapJavaType(field.javaType);
            String swaggerType = SWAGGER_TYPE_BY_JAVA_TYPE_NAME.getOrDefault(javaType, javaType);
            lines.add("  type: " + swaggerType);
            String swaggerFormat = SWAGGER_FORMAT_BY_JAVA_TYPE_NAME.get(swaggerType);
            if (swaggerFormat != null) {
                lines.add("  format: " + swaggerFormat);
            }
            if ("array".equals(javaType)) {
                lines.add("  items:");
                Class<?> genericsType = this.getGenericType(field.javaGenericsType);
                if (genericsType == null) {
                    genericsType = parentGenericTypes;
                }
                if (genericsType == null) {
                    genericsType = field.javaType.getComponentType();
                }
                String genericsTypeName = genericsType == null ? "unknown" : (EzyTypes.NON_ARRAY_TYPES.contains(genericsType) ? genericsType.getSimpleName().toLowerCase() : (Collection.class.isAssignableFrom(genericsType) ? "array" : "object"));
                String swaggerGenericsTypeName = SWAGGER_TYPE_BY_JAVA_TYPE_NAME.getOrDefault(genericsTypeName, genericsTypeName);
                lines.add("    type: " + swaggerGenericsTypeName);
                String swaggerGenericsFormat = SWAGGER_FORMAT_BY_JAVA_TYPE_NAME.get(swaggerGenericsTypeName);
                if (swaggerGenericsFormat != null) {
                    lines.add("    format: " + swaggerGenericsFormat);
                }
                if (!"object".equals(genericsTypeName)) continue;
                String line = "    " + this.createProperties(this.extractApiDataFields(genericsType, methodPrefix), NO_GENERICS_TYPE, doubleSpaces + 3, methodPrefix);
                lines.add(line);
                continue;
            }
            if (!"object".equals(javaType)) continue;
            String line = "  " + this.createProperties(this.extractApiDataFields(field.javaType, methodPrefix), NO_GENERICS_TYPE, doubleSpaces + 2, methodPrefix);
            lines.add(line);
        }
        return this.joinString(lines, doubleSpaces);
    }

    private ApiClass extractControllerClass(Class<?> controllerClass) {
        Api apiAnnotation = controllerClass.getAnnotation(Api.class);
        Controller controllerAnnotation = controllerClass.getAnnotation(Controller.class);
        Authenticated authenticatedAnnotation = controllerClass.getAnnotation(Authenticated.class);
        EzyFeature featureAnnotation = controllerClass.getAnnotation(EzyFeature.class);
        String uri = controllerAnnotation.uri();
        if (EzyStrings.isBlank((String)uri)) {
            uri = controllerAnnotation.value();
        }
        if (EzyStrings.isBlank((String)uri)) {
            uri = "/";
        }
        String feature = featureAnnotation == null ? "" : featureAnnotation.value();
        String finalUri = uri;
        List methods = EzyMethods.getMethods(controllerClass).stream().filter(it -> it.isAnnotationPresent(DoDelete.class) || it.isAnnotationPresent(DoGet.class) || it.isAnnotationPresent(DoPost.class) || it.isAnnotationPresent(DoPut.class)).map(it -> this.extractControllerMethod((Method)it, apiAnnotation != null, authenticatedAnnotation != null, finalUri, feature)).collect(Collectors.toList());
        return new ApiClass(methods.stream().collect(Collectors.groupingBy(it -> ((ApiMethod)it).uri, Collectors.toList())));
    }

    private ApiMethod extractControllerMethod(Method method, boolean parentIsApi, boolean parentIsAuthenticated, String parentUri, String parentFeature) {
        String uri;
        String type;
        DoDelete doDelete = method.getAnnotation(DoDelete.class);
        DoGet doGet = method.getAnnotation(DoGet.class);
        DoPost doPost = method.getAnnotation(DoPost.class);
        DoPut doPut = method.getAnnotation(DoPut.class);
        if (doDelete != null) {
            type = "delete";
            uri = doDelete.uri();
            if (EzyStrings.isBlank((String)uri)) {
                uri = doDelete.value();
            }
        } else if (doGet != null) {
            type = "get";
            uri = doGet.uri();
            if (EzyStrings.isBlank((String)uri)) {
                uri = doGet.value();
            }
        } else if (doPost != null) {
            type = "post";
            uri = doPost.uri();
            if (EzyStrings.isBlank((String)uri)) {
                uri = doPost.value();
            }
        } else {
            type = "put";
            uri = doPut.uri();
            if (EzyStrings.isBlank((String)uri)) {
                uri = doPut.value();
            }
        }
        String fullUri = parentUri;
        if (EzyStrings.isNotBlank((String)uri)) {
            fullUri = (parentUri + uri).replace("//", "/");
        }
        EzyFeature feature = method.getAnnotation(EzyFeature.class);
        Api api = method.getAnnotation(Api.class);
        Authenticated authenticated = method.getAnnotation(Authenticated.class);
        return new ApiMethod(method.getName(), type, fullUri, feature != null ? feature.value() : parentFeature, authenticated != null || parentIsAuthenticated, api != null || parentIsApi, this.extractParameters(fullUri, method), this.extractRequestBody(method), this.extractResponse(method));
    }

    private List<ApiParameter> extractParameters(String uri, Method method) {
        int index;
        ArrayList<String> pathVariables = new ArrayList<String>();
        String uriRemain = uri;
        while ((index = uriRemain.indexOf(123)) > 0 && (index = (uriRemain = uriRemain.substring(index + 1)).indexOf(125)) > 0) {
            pathVariables.add(uriRemain.substring(0, index));
            if (index >= uriRemain.length() - 1) break;
            uriRemain = uriRemain.substring(index + 1);
        }
        int pathVariableIndex = 0;
        ArrayList<ApiParameter> answer = new ArrayList<ApiParameter>();
        for (Parameter parameter : method.getParameters()) {
            RequestParam requestParamAnnotation;
            String name = null;
            String defaultValue = null;
            String in = null;
            PathVariable pathVariableAnnotation = parameter.getAnnotation(PathVariable.class);
            if (pathVariableAnnotation != null) {
                in = "path";
                name = pathVariableAnnotation.value();
                if (EzyStrings.isBlank((String)name)) {
                    name = pathVariableIndex < pathVariables.size() ? (String)pathVariables.get(pathVariableIndex) : "unknown";
                }
                ++pathVariableIndex;
            }
            if ((requestParamAnnotation = parameter.getAnnotation(RequestParam.class)) != null) {
                in = "query";
                name = requestParamAnnotation.value();
                if (EzyStrings.isBlank((String)name)) {
                    name = parameter.getName();
                }
                defaultValue = requestParamAnnotation.defaultValue();
            }
            if (in == null) continue;
            answer.add(new ApiParameter(in, name, parameter.getType(), this.getGenericType(parameter.getParameterizedType()), defaultValue));
        }
        return answer;
    }

    private ApiRequestBody extractRequestBody(Method method) {
        Class<?> requestBodyParamType = null;
        for (Parameter parameter : method.getParameters()) {
            if (!parameter.isAnnotationPresent(RequestBody.class)) continue;
            requestBodyParamType = parameter.getType();
            break;
        }
        if (requestBodyParamType == null) {
            return null;
        }
        List<ApiDataField> fields = this.extractApiDataFields(requestBodyParamType, "set");
        return new ApiRequestBody(fields);
    }

    private List<ApiDataField> extractApiDataFields(Class<?> clazz, String methodPrefix) {
        if (clazz == null) {
            return Collections.emptyList();
        }
        boolean isSetter = "set".equals(methodPrefix);
        return EzyMethods.getPublicMethods(clazz).stream().filter(it -> (it.getName().startsWith(methodPrefix) || it.getName().startsWith("is")) && (isSetter ? it.getParameterCount() > 0 : it.getParameterCount() == 0)).map(it -> new ApiDataField(isSetter ? EzyMethods.getFieldNameOfSetter((Method)it) : EzyMethods.getFieldNameOfGetter((Method)it), isSetter ? it.getParameterTypes()[0] : it.getReturnType(), isSetter ? it.getGenericParameterTypes()[0] : it.getGenericReturnType())).sorted(Comparator.comparing(a -> ((ApiDataField)a).name)).collect(Collectors.toList());
    }

    private ApiResponse extractResponse(Method method) {
        List<ApiDataField> fields = null;
        Class<?> responseBodyType = method.getReturnType();
        if (responseBodyType != Void.TYPE && responseBodyType != Redirect.class && responseBodyType != ResponseEntity.class && responseBodyType != View.class) {
            fields = this.extractApiDataFields(responseBodyType, "get");
        }
        return new ApiResponse(method.getReturnType(), this.getGenericType(method.getGenericReturnType()), fields);
    }

    private Class<?> getGenericType(Type type) {
        try {
            return EzyGenerics.getOneGenericClassArgument((Type)type);
        }
        catch (Exception e) {
            return null;
        }
    }

    private String joinString(List<String> lines, int doubleSpaces) {
        List notEmptyLines = lines.stream().filter(EzyStrings::isNotBlank).filter(it -> !it.trim().equals("'':")).collect(Collectors.toList());
        if (doubleSpaces == 0) {
            return String.join((CharSequence)"\n", notEmptyLines);
        }
        String spacesString = this.createSpaces(doubleSpaces);
        ArrayList<Object> answer = new ArrayList<Object>();
        answer.add(notEmptyLines.get(0));
        for (int i = 1; i < notEmptyLines.size(); ++i) {
            answer.add(spacesString + (String)notEmptyLines.get(i));
        }
        return String.join((CharSequence)"\n", answer);
    }

    private String createSpaces(int doubleSpaces) {
        return EzyStrings.newString((char)' ', (int)(doubleSpaces * 2));
    }

    private String mapJavaType(Class<?> javaType) {
        String type = javaType.isEnum() ? "string" : (javaType == BigInteger.class ? "integer" : (javaType == BigDecimal.class ? "double" : (EzyTypes.NON_ARRAY_TYPES.contains(javaType) ? (javaType == Boolean.TYPE || javaType == Boolean.class ? "boolean" : (javaType == Integer.TYPE || javaType == Integer.class || javaType == Byte.TYPE || javaType == Byte.class || javaType == Short.TYPE || javaType == Short.class ? "integer" : (javaType == Long.TYPE || javaType == Long.class ? "long" : (javaType == Float.TYPE || javaType == Float.class ? "float" : (javaType == Double.TYPE || javaType == Double.class ? "double" : "string"))))) : (javaType.isArray() ? "array" : (Collection.class.isAssignableFrom(javaType) ? "array" : "object")))));
        return type;
    }

    private String toFriendlyText(String s) {
        if (EzyStrings.isBlank((String)s)) {
            return s;
        }
        String withSpaces = s.replaceAll("[^\\p{L}\\p{Nd}]+", " ").replaceAll("([\\p{Ll}\\p{Nd}])(\\p{Lu})", "$1 $2").replaceAll("(\\p{Lu}+)(\\p{Lu}\\p{Ll})", "$1 $2").replaceAll("(\\p{L})(\\p{Nd})", "$1 $2").replaceAll("(\\p{Nd})(\\p{L})", "$1 $2").trim().replaceAll("\\s+", " ");
        String lower = Arrays.stream(withSpaces.split("\\s+")).map(String::toLowerCase).collect(Collectors.joining(" "));
        return lower.isEmpty() ? lower : Character.toUpperCase(lower.charAt(0)) + lower.substring(1);
    }

    public SwaggerGenerator(String packageToScan) {
        this.packageToScan = packageToScan;
    }

    private class SwaggerTemplate {
        private final Map<String, List<String>> templateByName;

        SwaggerTemplate() throws IOException {
            InputStream inputStream = new EzyAnywayInputStreamLoader().load("templates/swagger.txt");
            List lines = EzyInputStreams.toLines((InputStream)inputStream);
            this.templateByName = new HashMap<String, List<String>>();
            ArrayList<String> currentTemplateLines = new ArrayList<String>();
            for (String line : lines) {
                if (EzyStrings.isBlank((String)line)) continue;
                if (line.startsWith("#")) {
                    String currentTemplateName = line.substring(1).trim();
                    currentTemplateLines = new ArrayList();
                    this.templateByName.put(currentTemplateName, currentTemplateLines);
                    continue;
                }
                currentTemplateLines.add(line);
            }
        }

        private String createContent(String templateName, Map<String, Object> parameters, int doubleSpaces) {
            List lines = EzyLists.newArrayList((Collection)this.templateByName.get(templateName), it -> this.setLineParameters((String)it, parameters));
            return SwaggerGenerator.this.joinString(lines, doubleSpaces);
        }

        private String setLineParameters(String line, Map<String, Object> parameters) {
            String answer = line;
            for (Map.Entry<String, Object> e : parameters.entrySet()) {
                answer = answer.replace("${" + e.getKey() + "}", e.getValue().toString());
            }
            return answer;
        }
    }

    private static class ApiParameter {
        private String in;
        private final String name;
        private final Class<?> javaType;
        private final Class<?> javaGenericsType;
        private final String defaultValue;

        public ApiParameter(String in, String name, Class<?> javaType, Class<?> javaGenericsType, String defaultValue) {
            this.in = in;
            this.name = name;
            this.javaType = javaType;
            this.javaGenericsType = javaGenericsType;
            this.defaultValue = defaultValue;
        }
    }

    private static class ApiDataField {
        private final String name;
        private final Class<?> javaType;
        private final Type javaGenericsType;

        public ApiDataField(String name, Class<?> javaType, Type javaGenericsType) {
            this.name = name;
            this.javaType = javaType;
            this.javaGenericsType = javaGenericsType;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ApiDataField)) {
                return false;
            }
            ApiDataField other = (ApiDataField)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.name;
            String other$name = other.name;
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ApiDataField;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.name;
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }
    }

    private static class ApiResponse {
        private final Class<?> type;
        private final Class<?> genericsType;
        private final List<ApiDataField> fields;

        public ApiResponse(Class<?> type, Class<?> genericsType, List<ApiDataField> fields) {
            this.type = type;
            this.genericsType = genericsType;
            this.fields = fields;
        }
    }

    private static class ApiRequestBody {
        private final List<ApiDataField> fields;

        public ApiRequestBody(List<ApiDataField> fields) {
            this.fields = fields;
        }
    }

    public static class ApiMethod {
        private final String name;
        private final String type;
        private final String uri;
        private final String feature;
        private final boolean api;
        private final boolean authenticated;
        private final List<ApiParameter> parameters;
        private final ApiRequestBody requestBody;
        private final ApiResponse response;

        public ApiMethod(String name, String type, String uri, String feature, boolean api, boolean authenticated, List<ApiParameter> parameters, ApiRequestBody requestBody, ApiResponse response) {
            this.name = name;
            this.type = type;
            this.uri = uri;
            this.feature = feature;
            this.api = api;
            this.authenticated = authenticated;
            this.parameters = parameters;
            this.requestBody = requestBody;
            this.response = response;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ApiMethod)) {
                return false;
            }
            ApiMethod other = (ApiMethod)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$type = this.type;
            String other$type = other.type;
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$uri = this.uri;
            String other$uri = other.uri;
            return !(this$uri == null ? other$uri != null : !this$uri.equals(other$uri));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ApiMethod;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $type = this.type;
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $uri = this.uri;
            result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
            return result;
        }
    }

    public static class ApiClass {
        private final Map<String, List<ApiMethod>> methodsByUri;

        public ApiClass(Map<String, List<ApiMethod>> methodsByUri) {
            this.methodsByUri = methodsByUri;
        }
    }
}

