/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.manager;

import com.tvd12.ezyfox.annotation.EzyProperty;
import org.youngmonkeys.ezyplatform.entity.TargetType;
import org.youngmonkeys.ezyplatform.security.EzyPlatformDecryptor;
import org.youngmonkeys.ezyplatform.util.Uris;

public abstract class MarketUrlManager {
    @EzyProperty(value="market.url")
    protected String ezyplatformUrl = "https://ezyplatform.com";

    public String getPlatformGenerateNewKeyUrl(String version) {
        return this.resolveUrl("/api/v1/platforms/" + version + "/generate-new-key");
    }

    public String getSendStartupStatisticsUrl(String platformVersion) {
        return this.resolveUrl("/api/v1/platforms/" + platformVersion + "/targets/" + this.getTargetType().getName() + "/start");
    }

    protected abstract TargetType getTargetType();

    public void setEzyplatformUrl(String encryptedUrl) {
        try {
            this.ezyplatformUrl = EzyPlatformDecryptor.getInstance().decrypt(encryptedUrl);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String resolveUrl(String path) {
        return Uris.resolveUrl((String)this.ezyplatformUrl, (String)path);
    }

    public String getEzyplatformUrl() {
        return this.ezyplatformUrl;
    }
}

