/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyhttp.server.core.resources;

import com.tvd12.ezyfox.util.EzyFileUtil;
import com.tvd12.ezyhttp.server.core.resources.Resource;
import com.tvd12.ezyhttp.server.core.resources.ResourceFile;
import com.tvd12.ezyhttp.server.core.resources.ResourceLoader;
import com.tvd12.reflections.util.Sets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ResourceResolver {
    protected final Map<String, Resource> resources = new HashMap<String, Resource>();
    protected final ResourceLoader resourceLoader = new ResourceLoader();
    public static final String DEFAULT_RESOURCE_LOCATION = "static";
    public static final String DEFAULT_FILE_PATH_PATTERN = "[.\\/\\w\\d_-]+[.][\\w\\d_-]+";

    public void register(String location) {
        this.register(location, DEFAULT_FILE_PATH_PATTERN);
    }

    public void register(String[] locations) {
        this.register(locations, DEFAULT_FILE_PATH_PATTERN);
    }

    public void register(String[] locations, String ... filePathRegexes) {
        for (String location : locations) {
            this.register(location, filePathRegexes);
        }
    }

    public void register(String location, String ... filePathRegexes) {
        String trimLocation = location.trim();
        List<ResourceFile> resourceFiles = this.resourceLoader.listResourceFiles(trimLocation, Sets.newHashSet((Object[])filePathRegexes));
        for (ResourceFile res : resourceFiles) {
            String relativePath = res.getRelativePath();
            String resourceURI = relativePath.substring(trimLocation.length() + 1).replace('\\', '/');
            String extension = EzyFileUtil.getFileExtension((String)resourceURI);
            Resource resource = new Resource(relativePath, resourceURI, extension, res.getFullPath());
            this.resources.put(resourceURI, resource);
        }
    }

    public Map<String, Resource> getResources() {
        return this.resources;
    }
}

