/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyhttp.server.core.view;

import com.tvd12.ezyfox.util.EzyFileUtil;
import com.tvd12.ezyhttp.server.core.resources.ResourceFile;
import com.tvd12.ezyhttp.server.core.resources.ResourceLoader;
import com.tvd12.properties.file.reader.BaseFileReader;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;

public class MessageReader {
    private static final MessageReader DEFAULT = new MessageReader();
    private static final String MESSAGES_FILE_PATTERN = "^messages(|[_\\-\\w\\d]+).properties";

    public static MessageReader getDefault() {
        return DEFAULT;
    }

    public Map<String, Properties> read(String folderPath) {
        List<MessagesFile> files = this.getMessagesFiles(folderPath);
        HashMap<String, Properties> answer = new HashMap<String, Properties>();
        BaseFileReader fileReader = new BaseFileReader();
        for (MessagesFile file : files) {
            Properties properties = file.resourceFile.isInJar() ? fileReader.read(file.resourceFile.getRelativePath()) : fileReader.read(new File(file.resourceFile.getFullPath()));
            answer.computeIfAbsent(file.language, k -> new Properties()).putAll((Map<?, ?>)properties);
            answer.computeIfAbsent(file.language.toLowerCase(), k -> new Properties()).putAll((Map<?, ?>)properties);
        }
        return answer;
    }

    private List<MessagesFile> getMessagesFiles(String folderPath) {
        return this.listResourceFiles(folderPath).stream().filter(it -> it.isFileNameMatches(MESSAGES_FILE_PATTERN)).map(it -> {
            String fileName = EzyFileUtil.getFileName((String)it.getRelativePath());
            int index = fileName.indexOf(95);
            String lang = "";
            if (index > 0) {
                lang = fileName.substring(index + 1, fileName.lastIndexOf(46));
            }
            return new MessagesFile(lang, (ResourceFile)it);
        }).collect(Collectors.toList());
    }

    protected List<ResourceFile> listResourceFiles(String folderPath) {
        return new ResourceLoader().listResourceFiles(folderPath);
    }

    private static final class MessagesFile {
        private final String language;
        private final ResourceFile resourceFile;

        public MessagesFile(String language, ResourceFile resourceFile) {
            this.language = language;
            this.resourceFile = resourceFile;
        }
    }
}

