/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.nio.handler;

import com.tvd12.ezyfox.codec.EzyMessage;
import com.tvd12.ezyfox.codec.EzyMessageHeader;
import com.tvd12.ezyfox.codec.EzyMessageReaders;
import com.tvd12.ezyfox.concurrent.EzyExecutors;
import com.tvd12.ezyfox.constant.EzyConstant;
import com.tvd12.ezyfox.entity.EzyArray;
import com.tvd12.ezyfox.factory.EzyEntityFactory;
import com.tvd12.ezyfox.io.EzyBytes;
import com.tvd12.ezyfox.io.EzyInts;
import com.tvd12.ezyfox.io.EzyLongs;
import com.tvd12.ezyfox.util.EzyDestroyable;
import com.tvd12.ezyfox.util.EzyLoggable;
import com.tvd12.ezyfoxserver.api.EzyResponseApi;
import com.tvd12.ezyfoxserver.constant.EzyCommand;
import com.tvd12.ezyfoxserver.constant.EzyTransportType;
import com.tvd12.ezyfoxserver.entity.EzySession;
import com.tvd12.ezyfoxserver.nio.handler.EzyNioUdpDataHandler;
import com.tvd12.ezyfoxserver.nio.socket.EzySocketDataReceiver;
import com.tvd12.ezyfoxserver.nio.wrapper.EzyHandlerGroupManager;
import com.tvd12.ezyfoxserver.nio.wrapper.EzyHandlerGroupManagerAware;
import com.tvd12.ezyfoxserver.response.EzyPackage;
import com.tvd12.ezyfoxserver.socket.EzyDatagramChannelAware;
import com.tvd12.ezyfoxserver.socket.EzyDatagramChannelPool;
import com.tvd12.ezyfoxserver.socket.EzyDatagramChannelPoolAware;
import com.tvd12.ezyfoxserver.socket.EzySimplePackage;
import com.tvd12.ezyfoxserver.socket.EzyUdpClientAddressAware;
import com.tvd12.ezyfoxserver.socket.EzyUdpReceivedPacket;
import com.tvd12.ezyfoxserver.wrapper.EzySessionManager;
import com.tvd12.ezyfoxserver.wrapper.EzySessionManagerAware;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.DatagramChannel;
import java.util.concurrent.ExecutorService;

public class EzySimpleNioUdpDataHandler
extends EzyLoggable
implements EzyNioUdpDataHandler,
EzySessionManagerAware,
EzyHandlerGroupManagerAware,
EzyDatagramChannelPoolAware,
EzyDestroyable {
    protected final ExecutorService executorService;
    protected EzyResponseApi responseApi;
    protected EzySessionManager sessionManager;
    protected EzyHandlerGroupManager handlerGroupManager;
    protected EzyDatagramChannelPool datagramChannelPool;
    protected EzySocketDataReceiver socketDataReceiver;

    public EzySimpleNioUdpDataHandler(int threadPoolSize) {
        this.executorService = EzyExecutors.newFixedThreadPool((int)threadPoolSize, (String)"udp-data-handler");
    }

    @Override
    public void fireUdpPacketReceived(EzyUdpReceivedPacket packet) {
        this.executorService.execute(() -> this.handleReceivedUdpPacket(packet));
    }

    protected void handleReceivedUdpPacket(EzyUdpReceivedPacket packet) {
        try {
            EzyMessage message = EzyMessageReaders.bytesToMessage((byte[])packet.getBytes());
            if (message == null) {
                return;
            }
            InetSocketAddress udpAddress = packet.getAddress();
            Object socketChannel = this.handlerGroupManager.getSocketChannel(udpAddress);
            if (socketChannel != null) {
                this.socketDataReceiver.udpReceive(socketChannel, message);
            } else {
                EzyMessageHeader header = message.getHeader();
                if (header.isUdpHandshake()) {
                    this.handleUdpHandshake(packet.getChannel(), udpAddress, message);
                }
            }
        }
        catch (Throwable e) {
            this.logger.warn("handle received udp package: {} error: {}({})", new Object[]{packet, e.getClass().getName(), e.getMessage()});
        }
    }

    protected void handleUdpHandshake(DatagramChannel channel, InetSocketAddress address, EzyMessage message) throws Exception {
        byte[] content = message.getContent();
        if (content.length < 11) {
            return;
        }
        byte[] sessionIdBytes = EzyBytes.copy((byte[])content, (int)0, (int)8);
        long sessionId = EzyLongs.bin2long((byte[])sessionIdBytes);
        byte[] tokenSizeBytes = EzyBytes.copy((byte[])content, (int)8, (int)2);
        int tokenSize = EzyInts.bin2int((byte[])tokenSizeBytes);
        if (tokenSize > 512) {
            return;
        }
        byte[] tokenBytes = EzyBytes.copy((byte[])content, (int)10, (int)tokenSize);
        EzySession session = this.sessionManager.getSession(sessionId);
        if (session == null) {
            return;
        }
        int responseCode = 498;
        String token = new String(tokenBytes);
        String sessionToken = session.getToken();
        if (sessionToken.equals(token)) {
            responseCode = 200;
            SocketAddress oldUdpAddress = session.getUdpClientAddress();
            this.handlerGroupManager.unmapHandlerGroup(oldUdpAddress);
            this.handlerGroupManager.mapSocketChannel(address, session);
            ((EzyDatagramChannelAware)session).setDatagramChannel(channel);
            ((EzyUdpClientAddressAware)session).setUdpClientAddress((SocketAddress)address);
            ((EzyDatagramChannelPoolAware)session).setDatagramChannelPool(this.datagramChannelPool);
        }
        this.response(session, responseCode);
    }

    protected void response(EzySession recipient, int responseCode) throws Exception {
        EzyArray responseData = EzyEntityFactory.newArray();
        responseData.add((Object)responseCode);
        EzyArray responseCommand = EzyEntityFactory.newArray();
        responseCommand.add((Object)EzyCommand.UDP_HANDSHAKE.getId());
        responseCommand.add((Object)responseData);
        EzySimplePackage response = new EzySimplePackage();
        response.addRecipient(recipient);
        response.setTransportType((EzyConstant)EzyTransportType.UDP);
        response.setData(responseCommand);
        this.responseApi.response((EzyPackage)response);
        this.logger.debug("response udp handshake to: {}, code: {}", (Object)recipient, (Object)responseCode);
    }

    public void destroy() {
        this.executorService.shutdownNow();
    }

    public void setResponseApi(EzyResponseApi responseApi) {
        this.responseApi = responseApi;
    }

    public void setSessionManager(EzySessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    @Override
    public void setHandlerGroupManager(EzyHandlerGroupManager handlerGroupManager) {
        this.handlerGroupManager = handlerGroupManager;
    }

    public void setDatagramChannelPool(EzyDatagramChannelPool datagramChannelPool) {
        this.datagramChannelPool = datagramChannelPool;
    }

    public void setSocketDataReceiver(EzySocketDataReceiver socketDataReceiver) {
        this.socketDataReceiver = socketDataReceiver;
    }
}

