/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.config;

import com.tvd12.ezyfox.bean.EzyBeanConfig;
import com.tvd12.ezyfox.bean.annotation.EzyAutoBind;
import com.tvd12.ezyfox.bean.annotation.EzyConfigurationAfter;
import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyfox.util.EzyLoggable;
import com.tvd12.ezyhttp.core.net.URIBuilder;
import com.tvd12.properties.file.util.PropertiesUtil;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.youngmonkeys.ezyplatform.admin.data.Menu;
import org.youngmonkeys.ezyplatform.admin.data.Module;
import org.youngmonkeys.ezyplatform.admin.manager.AdminEnvironmentManager;
import org.youngmonkeys.ezyplatform.admin.manager.AdminMenuManager;
import org.youngmonkeys.ezyplatform.admin.manager.AdminModuleManager;
import org.youngmonkeys.ezyplatform.admin.util.AdminSortedMaps;
import org.youngmonkeys.ezyplatform.entity.ModuleType;
import org.youngmonkeys.ezyplatform.util.Uris;

@EzyConfigurationAfter
public class AdminMenuConfig
extends EzyLoggable
implements EzyBeanConfig {
    @EzyAutoBind
    private AdminMenuManager menuManager;
    @EzyAutoBind
    private AdminModuleManager moduleManager;
    @EzyAutoBind
    private AdminEnvironmentManager environmentManager;

    public void config() {
        List<Module> modules = this.moduleManager.getModules(ModuleType.ADMIN_PLUGIN);
        for (Module module : modules) {
            SortedMap<String, String> menusDefinition;
            if (!module.isActive() && !this.environmentManager.isDebugMode() || (menusDefinition = this.moduleManager.readMenuProperties(module.getType(), module.getName(), module.getMenusFile())).isEmpty()) continue;
            this.addMenu(module.getName(), menusDefinition);
        }
    }

    private void addMenu(String moduleName, SortedMap<String, String> menusDefinition) {
        List sectionNames = PropertiesUtil.getFirstPropertyKeyList(menusDefinition);
        for (String sectionName : sectionNames) {
            SortedMap sectionProperties = AdminSortedMaps.getMapByPrefix(menusDefinition, (String)sectionName);
            List menuNames = PropertiesUtil.getFirstPropertyKeyList((Map)sectionProperties);
            for (String menuName : menuNames) {
                SortedMap menuProperties = AdminSortedMaps.getMapByPrefix((Map)sectionProperties, (String)menuName);
                if (menuProperties.isEmpty()) continue;
                this.addMenu(moduleName, sectionName, menuName, menuProperties);
            }
        }
    }

    private void addMenu(String moduleName, String sectionName, String menuName, SortedMap<String, String> menuProperties) {
        boolean isMenuVisible;
        String moduleNameDashCase = EzyStrings.toDashCase((String)moduleName);
        String menuOriginalUrl = menuProperties.getOrDefault("", "");
        boolean bl = isMenuVisible = !menuOriginalUrl.startsWith("~");
        if (!isMenuVisible) {
            menuOriginalUrl = menuOriginalUrl.substring(1);
        }
        String menuUrl = Uris.uriStartsWith((String)menuOriginalUrl, (String)moduleNameDashCase) ? menuOriginalUrl : URIBuilder.normalizePath((String)("/" + moduleNameDashCase + "/" + menuOriginalUrl));
        MenuUriIcon menuUriIcon = MenuUriIcon.parse(menuUrl);
        Menu menu = this.menuManager.addMenu(moduleName, sectionName, menuName, menuUriIcon.uri, menuUriIcon.icon, isMenuVisible);
        List menuItemNames = PropertiesUtil.getFirstPropertyKeyList(menuProperties);
        for (String menuItemName : menuItemNames) {
            boolean isMenuItemVisible;
            String menuItemOriginalUrl;
            if (EzyStrings.isBlank((String)menuItemName) || EzyStrings.isBlank((String)(menuItemOriginalUrl = (String)menuProperties.get(menuItemName)))) continue;
            boolean bl2 = isMenuItemVisible = !menuItemOriginalUrl.startsWith("~");
            if (!isMenuItemVisible) {
                menuItemOriginalUrl = menuItemOriginalUrl.substring(1);
            }
            String menuItemUrl = Uris.uriStartsWith((String)menuItemOriginalUrl, (String)moduleNameDashCase) ? menuItemOriginalUrl : URIBuilder.normalizePath((String)("/" + EzyStrings.toDashCase((String)moduleName) + "/" + menuItemOriginalUrl));
            MenuUriIcon menuItemUriIcon = MenuUriIcon.parse(menuItemUrl);
            this.menuManager.addMenuItem(sectionName, menu.getFullName(), menuItemName, menuItemUriIcon.uri, menuItemUriIcon.icon, isMenuItemVisible);
        }
    }

    public void setMenuManager(AdminMenuManager menuManager) {
        this.menuManager = menuManager;
    }

    public void setModuleManager(AdminModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }

    public void setEnvironmentManager(AdminEnvironmentManager environmentManager) {
        this.environmentManager = environmentManager;
    }

    private static class MenuUriIcon {
        private final String uri;
        private final String icon;

        private static MenuUriIcon parse(String originalUri) {
            int index = originalUri.lastIndexOf(59);
            if (index <= 0) {
                return new MenuUriIcon(originalUri.trim(), null);
            }
            return new MenuUriIcon(originalUri.substring(0, index).trim(), originalUri.substring(index + 1).trim());
        }

        public MenuUriIcon(String uri, String icon) {
            this.uri = uri;
            this.icon = icon;
        }
    }
}

