/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.config;

import com.tvd12.ezyfox.bean.EzyBeanConfig;
import com.tvd12.ezyfox.bean.annotation.EzyAutoBind;
import com.tvd12.ezyfox.bean.annotation.EzyConfigurationAfter;
import org.youngmonkeys.ezyplatform.admin.data.Module;
import org.youngmonkeys.ezyplatform.admin.manager.AdminModuleManager;
import org.youngmonkeys.ezyplatform.admin.model.AddAdminProjectModel;
import org.youngmonkeys.ezyplatform.admin.service.AdminProjectService;
import org.youngmonkeys.ezyplatform.constant.ModuleAction;
import org.youngmonkeys.ezyplatform.entity.ModuleType;

@EzyConfigurationAfter(priority=0x7FFFFFFF)
public class AdminModulesConfig
implements EzyBeanConfig {
    @EzyAutoBind
    private AdminModuleManager moduleManager;
    @EzyAutoBind
    private AdminProjectService projectService;

    public void config() {
        this.activateDefaultTheme();
        this.activateDefaultSocketMonitorPlugin();
    }

    private void activateDefaultTheme() {
        Module defaultTheme = this.moduleManager.activateDefaultThemeIfNeed();
        if (defaultTheme != null) {
            this.projectService.addProject(AddAdminProjectModel.builder().projectName("welcome").version(defaultTheme.getVersion()).adminId(this.getDefaultAdminId()).build());
        }
    }

    private void activateDefaultSocketMonitorPlugin() {
        Module plugin = this.moduleManager.getModule(ModuleType.SOCKET_PLUGIN, "socket-monitor");
        if (plugin == null || plugin.isActive()) {
            return;
        }
        this.moduleManager.actModule(ModuleType.SOCKET_PLUGIN, "socket-monitor", ModuleAction.ACTIVATE);
        this.projectService.addProject(AddAdminProjectModel.builder().projectName("socket-monitor").version(plugin.getVersion()).adminId(this.getDefaultAdminId()).build());
    }

    private long getDefaultAdminId() {
        return 1L;
    }

    public void setModuleManager(AdminModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }

    public void setProjectService(AdminProjectService projectService) {
        this.projectService = projectService;
    }
}

