/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.controller.api;

import com.tvd12.ezyfox.util.EzyFileUtil;
import com.tvd12.ezyfox.util.EzyLoggable;
import com.tvd12.ezyhttp.client.HttpClient;
import com.tvd12.ezyhttp.client.request.GetRequest;
import com.tvd12.ezyhttp.client.request.Request;
import com.tvd12.ezyhttp.client.request.RequestEntity;
import com.tvd12.ezyhttp.core.constant.ContentType;
import com.tvd12.ezyhttp.core.response.ResponseEntity;
import com.tvd12.ezyhttp.server.core.annotation.Api;
import com.tvd12.ezyhttp.server.core.annotation.Authenticated;
import com.tvd12.ezyhttp.server.core.annotation.Controller;
import com.tvd12.ezyhttp.server.core.annotation.DoGet;
import com.tvd12.ezyhttp.server.core.annotation.PathVariable;
import com.tvd12.ezyhttp.server.core.annotation.RequestCookie;
import com.tvd12.ezyhttp.server.core.annotation.RequestParam;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.youngmonkeys.ezyplatform.admin.data.ModuleDependency;
import org.youngmonkeys.ezyplatform.admin.manager.AdminMarketUrlManager;

@Api
@Authenticated
@Controller(value="/api/v1")
public class AdminApiMarketProxyController
extends EzyLoggable {
    private final HttpClient httpClient;
    private final AdminMarketUrlManager marketUrlManager;

    @DoGet(uri="/market/media/{name}", responseType="application/octet-stream")
    public ResponseEntity mediaNameGet(HttpServletResponse response, @PathVariable String name) throws Exception {
        String extension = EzyFileUtil.getFileExtension((String)name);
        String contentType = ContentType.ofExtension((String)extension).getValue();
        response.setContentType(contentType);
        this.httpClient.download(this.marketUrlManager.getMediaByNameUrl(name), (OutputStream)response.getOutputStream());
        return ResponseEntity.builder().status(200).contentType(contentType).build();
    }

    @DoGet(value="/released-projects")
    public Object releaseProjectsGet(@RequestCookie(value="marketAccessToken") String marketAccessToken, @RequestParam(value="moduleType") String moduleType, @RequestParam(value="projectName") String projectName, @RequestParam(value="keyword") String keyword, @RequestParam(value="nextPageToken") String nextPageToken, @RequestParam(value="prevPageToken") String prevPageToken, @RequestParam(value="lastPage") boolean lastPage, @RequestParam(value="limit", defaultValue="30") int limit) throws Exception {
        return this.httpClient.call((Request)((GetRequest)new GetRequest().setEntity(RequestEntity.builder().header("accessToken", marketAccessToken).build())).setURL(this.marketUrlManager.getReleasedProjectsUrl(moduleType, projectName, keyword, nextPageToken, prevPageToken, lastPage, limit)));
    }

    @DoGet(value="/released-projects/{projectName}")
    public Object releaseProjectsProjectNameGet(@PathVariable String projectName) throws Exception {
        return this.httpClient.call((Request)new GetRequest().setURL(this.marketUrlManager.getReleasedProjectsByNameUrl(projectName)));
    }

    @DoGet(value="/released-projects-simple-data")
    public Object releaseProjectsSimpleDataGet(@RequestParam(value="projectNames") String projectNames) throws Exception {
        return this.httpClient.call((Request)new GetRequest().setURL(this.marketUrlManager.getReleasedProjectsSimpleDataUrl(projectNames)));
    }

    @DoGet(value="/released-projects-existing-filter")
    public List<String> releasedProjectsExistingFilterGet(@RequestParam(value="projectAndVersions") Set<String> projectAndVersions) {
        return projectAndVersions.parallelStream().map(ModuleDependency::parseOne).filter(this::isProjectVersionExisting).map(ModuleDependency::getProjectName).collect(Collectors.toList());
    }

    private boolean isProjectVersionExisting(ModuleDependency projectVersion) {
        try {
            GetRequest request = (GetRequest)((GetRequest)new GetRequest().setResponseType(Map.class)).setURL(this.marketUrlManager.getReleasedProjectsProjectNameVersionNameExistingUrl(projectVersion.getProjectName(), projectVersion.getProjectVersion()));
            Map result = (Map)this.httpClient.call((Request)request);
            return result.getOrDefault("existing", Boolean.FALSE);
        }
        catch (Exception e) {
            this.logger.info("check project version: {} existing failed", (Object)projectVersion, (Object)e);
            return false;
        }
    }

    public AdminApiMarketProxyController(HttpClient httpClient, AdminMarketUrlManager marketUrlManager) {
        this.httpClient = httpClient;
        this.marketUrlManager = marketUrlManager;
    }
}

