/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.io;

import com.tvd12.ezyfox.bean.annotation.EzySingleton;
import com.tvd12.ezyfox.util.EzyLoggable;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import org.youngmonkeys.ezyplatform.admin.manager.AdminFileSystemManager;
import org.youngmonkeys.ezyplatform.entity.TargetType;
import org.youngmonkeys.ezyplatform.io.FolderProxy;

@EzySingleton
public class AdminVmOptionsInteractor
extends EzyLoggable {
    private final AdminFileSystemManager fileSystemManager;
    private static final String FILE_VM_OPTIONS = "vm-options.txt";

    public void saveVmOptions(TargetType targetType, String vmOptions) throws IOException {
        File file = this.fileSystemManager.concatWithEzyHome(Paths.get(targetType.getName(), FILE_VM_OPTIONS));
        FolderProxy.createNewFile((File)file);
        Files.write(file.toPath(), (vmOptions + "\n").getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    public String readVmOptionsFile(TargetType targetType) {
        File file = this.fileSystemManager.concatWithEzyHome(Paths.get(targetType.getName(), FILE_VM_OPTIONS));
        String vmOptions = "";
        if (file.exists()) {
            try {
                vmOptions = new String(Files.readAllBytes(file.toPath()), StandardCharsets.UTF_8).trim();
            }
            catch (IOException e) {
                this.logger.warn("read vm options file failed", (Throwable)e);
            }
        }
        return vmOptions;
    }

    public AdminVmOptionsInteractor(AdminFileSystemManager fileSystemManager) {
        this.fileSystemManager = fileSystemManager;
    }
}

