/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.pipeline;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyfox.util.EzyLoggable;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.youngmonkeys.ezyplatform.admin.pipeline.AdminDataPipelineWorker;
import org.youngmonkeys.ezyplatform.admin.service.AdminSettingService;

public abstract class AdminDataPipelineProcessingWorker<I, O, P>
extends EzyLoggable
implements AdminDataPipelineWorker {
    private final ObjectMapper objectMapper;
    private final AdminSettingService settingService;
    private final AtomicReference<P> lastPageToken = new AtomicReference();

    @Override
    public final void run() {
        try {
            this.preRun();
            this.doRun();
        }
        catch (Exception e) {
            this.logger.warn("data pipeline worker run error", (Throwable)e);
        }
    }

    @Override
    public void reset() {
        this.lastPageToken.set(this.defaultPageToken());
    }

    protected void preRun() {
    }

    private void doRun() {
        List<I> valueList;
        P pageToken = this.lastPageToken.get();
        if (pageToken == null) {
            pageToken = this.loadLastPageToken();
            this.lastPageToken.set(pageToken);
        }
        if (!(valueList = this.getValueList(pageToken)).isEmpty()) {
            List<I> filteredValueList = this.filterValueList(valueList);
            List outputValues = filteredValueList.stream().flatMap(it -> this.toOutputValues(it).stream()).collect(Collectors.toList());
            outputValues.parallelStream().forEach(this::addOutputValue);
        }
        P newPageToken = this.extractNewLastPageToken(valueList, pageToken);
        this.lastPageToken.set(newPageToken);
        String pageTokenString = this.serializePageToken(newPageToken);
        if (EzyStrings.isNotBlank((String)pageTokenString)) {
            this.settingService.setTextValue(this.getPageTokenSettingKey(), pageTokenString);
        }
    }

    protected abstract List<I> getValueList(P var1);

    protected List<I> filterValueList(List<I> valueList) {
        return valueList;
    }

    protected abstract Collection<O> toOutputValues(I var1);

    protected abstract void addOutputValue(O var1);

    protected abstract P extractNewLastPageToken(List<I> var1, P var2);

    private String serializePageToken(P pageToken) {
        try {
            return this.objectMapper.writeValueAsString(pageToken);
        }
        catch (Exception e) {
            this.logger.warn("serialize page token: {} error", pageToken, (Object)e);
            return null;
        }
    }

    private P loadLastPageToken() {
        String pageTokenString = this.settingService.getTextValue(this.getPageTokenSettingKey());
        try {
            return (P)(EzyStrings.isBlank((String)pageTokenString) ? this.defaultPageToken() : this.objectMapper.readValue(pageTokenString, this.pageTokenType()));
        }
        catch (Exception e) {
            return this.defaultPageToken();
        }
    }

    private String getPageTokenSettingKey() {
        return this.getWorkerNamePrefix() + "_processing_worker";
    }

    protected abstract String getWorkerNamePrefix();

    protected abstract P defaultPageToken();

    protected abstract Class<P> pageTokenType();

    public AdminDataPipelineProcessingWorker(ObjectMapper objectMapper, AdminSettingService settingService) {
        this.objectMapper = objectMapper;
        this.settingService = settingService;
    }
}

