/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.socket;

import com.tvd12.ezyfox.util.EzyProcessor;
import com.tvd12.ezyfoxserver.entity.EzySession;
import com.tvd12.ezyfoxserver.socket.EzySocketAbstractEventHandler;
import com.tvd12.ezyfoxserver.socket.EzySocketDataHandlerGroup;
import com.tvd12.ezyfoxserver.socket.EzySocketDataHandlerGroupFetcher;
import com.tvd12.ezyfoxserver.socket.EzySocketStream;
import com.tvd12.ezyfoxserver.socket.EzySocketStreamQueue;

public class EzySocketStreamHandler
extends EzySocketAbstractEventHandler {
    protected EzySocketStreamQueue streamQueue;
    protected EzySocketDataHandlerGroupFetcher dataHandlerGroupFetcher;

    @Override
    public void handleEvent() {
        try {
            EzySocketStream stream = this.streamQueue.take();
            this.processStream(stream);
        }
        catch (InterruptedException e) {
            this.logger.warn("socket-stream-handler thread interrupted");
        }
        catch (Throwable throwable) {
            this.logger.warn("problems in socket-stream-handler", throwable);
        }
    }

    public void destroy() {
        EzyProcessor.processWithLogException(this.streamQueue::clear);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processStream(EzySocketStream stream) throws Exception {
        try {
            byte[] bytes = stream.getBytes();
            EzySession session = stream.getSession();
            EzySocketDataHandlerGroup handlerGroup = this.getDataHandlerGroup(session);
            if (handlerGroup != null) {
                handlerGroup.fireStreamBytesReceived(bytes);
            } else {
                this.logger.warn("has no handler group with session: {}, drop: {} bytes", (Object)session, (Object)bytes.length);
            }
        }
        finally {
            stream.release();
        }
    }

    protected EzySocketDataHandlerGroup getDataHandlerGroup(EzySession session) {
        return this.dataHandlerGroupFetcher.getDataHandlerGroup(session);
    }

    public void setStreamQueue(EzySocketStreamQueue streamQueue) {
        this.streamQueue = streamQueue;
    }

    public void setDataHandlerGroupFetcher(EzySocketDataHandlerGroupFetcher dataHandlerGroupFetcher) {
        this.dataHandlerGroupFetcher = dataHandlerGroupFetcher;
    }
}

