/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.reflections.vfs;

import com.tvd12.reflections.util.AbstractIterator;
import com.tvd12.reflections.util.Lists;
import com.tvd12.reflections.vfs.SystemFile;
import com.tvd12.reflections.vfs.Vfs;
import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;

public class SystemDir
implements Vfs.Dir {
    private final File file;

    public SystemDir(File file) {
        if (!(file == null || file.isDirectory() && file.canRead())) {
            throw new RuntimeException("cannot use dir " + file);
        }
        this.file = file;
    }

    @Override
    public String getPath() {
        if (this.file == null) {
            return "/NO-SUCH-DIRECTORY/";
        }
        return this.file.getPath().replace("\\", "/");
    }

    @Override
    public Iterable<Vfs.File> getFiles() {
        if (this.file == null || !this.file.exists()) {
            return Collections.emptyList();
        }
        return new Iterable<Vfs.File>(){

            @Override
            public Iterator<Vfs.File> iterator() {
                return new AbstractIterator<Vfs.File>(){
                    final Stack<File> stack = new Stack();
                    {
                        this.stack.addAll(SystemDir.listFiles(SystemDir.this.file));
                    }

                    @Override
                    protected Vfs.File computeNext() {
                        while (!this.stack.isEmpty()) {
                            File file = this.stack.pop();
                            if (file.isDirectory()) {
                                this.stack.addAll(SystemDir.listFiles(file));
                                continue;
                            }
                            return new SystemFile(SystemDir.this, file);
                        }
                        return (Vfs.File)this.endOfData();
                    }
                };
            }
        };
    }

    private static List<File> listFiles(File file) {
        File[] files = file.listFiles();
        if (files != null) {
            return Lists.newArrayList(files);
        }
        return Lists.newArrayList(new File[0]);
    }

    @Override
    public void close() {
    }

    public String toString() {
        return this.getPath();
    }
}

