/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.web.config;

import com.tvd12.ezyfox.bean.EzyBeanConfig;
import com.tvd12.ezyfox.io.EzySets;
import com.tvd12.ezyhttp.core.constant.HttpMethod;
import com.tvd12.ezyhttp.server.core.manager.FeatureURIManager;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.youngmonkeys.ezyplatform.constant.CommonConstants;
import org.youngmonkeys.ezyplatform.entity.RoleFeature;
import org.youngmonkeys.ezyplatform.entity.RoleFeatureId;
import org.youngmonkeys.ezyplatform.entity.TargetType;
import org.youngmonkeys.ezyplatform.entity.UserRoleName;
import org.youngmonkeys.ezyplatform.time.ClockProxy;
import org.youngmonkeys.ezyplatform.web.repo.WebRoleFeatureRepository;
import org.youngmonkeys.ezyplatform.web.repo.WebUserRoleNameRepository;
import org.youngmonkeys.ezyplatform.web.service.WebSettingService;

public abstract class WebRoleFeatureConfig
implements EzyBeanConfig {
    private final ClockProxy clock;
    private final FeatureURIManager featureUriManager;
    private final WebSettingService settingService;
    private final WebUserRoleNameRepository userRoleNameRepository;
    private final WebRoleFeatureRepository roleFeatureRepository;

    public void config() {
        UserRoleName roleName = (UserRoleName)this.userRoleNameRepository.findByField("name", this.getRoleName());
        if (roleName != null) {
            this.saveRoleFeatures(roleName.getId());
        }
    }

    private void saveRoleFeatures(long roleId) {
        String targetType = TargetType.WEB.toString();
        HashSet<RoleFeatureId> roleFeatureIds = new HashSet<RoleFeatureId>();
        for (String feature : this.getFeatures()) {
            Map methodsByUri = this.featureUriManager.getURIsByFeature(feature);
            for (Map.Entry e : methodsByUri.entrySet()) {
                String uri = (String)e.getKey();
                for (HttpMethod method : (List)e.getValue()) {
                    RoleFeatureId roleFeatureId = new RoleFeatureId();
                    roleFeatureId.setRoleId(roleId);
                    roleFeatureId.setTarget(targetType);
                    roleFeatureId.setFeature(feature);
                    roleFeatureId.setFeatureUri(uri);
                    roleFeatureId.setFeatureMethod(method.toString());
                    roleFeatureIds.add(roleFeatureId);
                }
            }
        }
        List savedRoleFeatures = this.roleFeatureRepository.findListByIds(roleFeatureIds);
        Set savedRoleFeatureIds = EzySets.newHashSet((Collection)savedRoleFeatures, RoleFeature::identifier);
        LocalDateTime now = this.clock.nowDateTime();
        List newRoleFeatures = roleFeatureIds.stream().filter(it -> !savedRoleFeatureIds.contains(it)).map(it -> {
            RoleFeature entity = new RoleFeature();
            entity.setRoleId(it.getRoleId());
            entity.setTarget(it.getTarget());
            entity.setFeature(it.getFeature());
            entity.setFeatureUri(it.getFeatureUri());
            entity.setFeatureMethod(it.getFeatureMethod());
            entity.setCreatedAt(now);
            return entity;
        }).collect(Collectors.toList());
        if (!newRoleFeatures.isEmpty()) {
            this.roleFeatureRepository.save(newRoleFeatures);
            this.settingService.setLastUpdateTime(CommonConstants.settingNameTargetRoleFeatures((String)targetType));
        }
    }

    protected abstract String getRoleName();

    protected Set<String> getFeatures() {
        return Collections.singleton(this.getRoleName());
    }

    @Generated
    public WebRoleFeatureConfig(ClockProxy clock, FeatureURIManager featureUriManager, WebSettingService settingService, WebUserRoleNameRepository userRoleNameRepository, WebRoleFeatureRepository roleFeatureRepository) {
        this.clock = clock;
        this.featureUriManager = featureUriManager;
        this.settingService = settingService;
        this.userRoleNameRepository = userRoleNameRepository;
        this.roleFeatureRepository = roleFeatureRepository;
    }
}

