/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.asm;

import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyfox.reflect.EzyClasses;
import com.tvd12.ezyfox.reflect.EzyTypes;
import java.util.HashMap;
import java.util.Map;

public class EzyInstruction {
    protected final String end;
    protected final boolean semicolon;
    protected final StringBuilder builder = new StringBuilder();
    protected static final Map<Class, Class> PRIMITIVE_WRAPPER_TYPES = EzyTypes.PRIMITIVE_WRAPPER_TYPES_MAP;
    private static final Map<Class, String> FETCH_PRIMITIVE_METHODS = EzyInstruction.fetchPrimitiveMethods();

    public EzyInstruction() {
        this("");
    }

    public EzyInstruction(String begin) {
        this(begin, "");
    }

    public EzyInstruction(String begin, String end) {
        this(begin, end, true);
    }

    public EzyInstruction(String begin, String end, boolean semicolon) {
        this.end = end;
        this.builder.append(begin);
        this.semicolon = semicolon;
    }

    private static Map<Class, String> fetchPrimitiveMethods() {
        HashMap<Class, String> map = new HashMap<Class, String>();
        map.put(Boolean.class, "booleanValue()");
        map.put(Byte.class, "byteValue()");
        map.put(Character.class, "charValue()");
        map.put(Double.class, "doubleValue()");
        map.put(Float.class, "floatValue()");
        map.put(Integer.class, "intValue()");
        map.put(Long.class, "longValue()");
        map.put(Short.class, "shortValue()");
        return map;
    }

    public EzyInstruction equal() {
        this.builder.append(" = ");
        return this;
    }

    public EzyInstruction finish() {
        this.builder.append(";");
        return this;
    }

    public EzyInstruction constructor(Class clazz) {
        return this.clazz(clazz).append("()");
    }

    public EzyInstruction append(Object value) {
        this.builder.append(value.toString());
        return this;
    }

    public EzyInstruction append(String str) {
        this.builder.append(str);
        return this;
    }

    public EzyInstruction append(EzyInstruction instruction) {
        return this.append(instruction.toString());
    }

    public EzyInstruction string(String str) {
        this.builder.append("\"").append(str).append("\"");
        return this;
    }

    public EzyInstruction clazz(Class clazz) {
        return this.clazz(clazz, false);
    }

    public EzyInstruction clazz(Class clazz, boolean extension) {
        this.append(clazz.getTypeName());
        return extension ? this.append(".class") : this;
    }

    public EzyInstruction dot() {
        return this.append(".");
    }

    public EzyInstruction comma() {
        return this.append(", ");
    }

    public EzyInstruction bracketopen() {
        return this.append("(");
    }

    public EzyInstruction bracketclose() {
        return this.append(")");
    }

    public EzyInstruction brackets(Class clazz) {
        this.builder.append("(").append(clazz.getTypeName()).append(")");
        return this;
    }

    public EzyInstruction brackets(String expression) {
        this.builder.append("(").append(expression).append(")");
        return this;
    }

    public EzyInstruction answer() {
        return this.append("return ");
    }

    public EzyInstruction variable(Class type) {
        return this.variable(type, EzyClasses.getVariableName(type));
    }

    public EzyInstruction variable(Class type, String name) {
        this.builder.append(type.getTypeName()).append(" ").append(name);
        return this;
    }

    public EzyInstruction cast(Class type, String expression) {
        if (PRIMITIVE_WRAPPER_TYPES.containsKey(type)) {
            return this.castPrimitive(type, expression);
        }
        return this.castNormal(type, expression);
    }

    protected EzyInstruction castNormal(Class type, String expression) {
        this.builder.append("(").append("(").append(type.getTypeName()).append(")").append("(").append(expression).append(")").append(")");
        return this;
    }

    protected EzyInstruction castPrimitive(Class type, String expression) {
        Class wrapperType = PRIMITIVE_WRAPPER_TYPES.get(type);
        String primitiveValueMethod = FETCH_PRIMITIVE_METHODS.get(wrapperType);
        this.castNormal(wrapperType, expression);
        this.dot();
        this.append(primitiveValueMethod);
        return this;
    }

    public EzyInstruction function(String method, String ... args) {
        return this.append(method).brackets(EzyStrings.join(args, ", "));
    }

    public EzyInstruction invoke(String object, String method, String ... args) {
        return this.append(object).dot().function(method, args);
    }

    public EzyInstruction valueOf(Class type, String expression) {
        return this.valueOf(type, expression, false);
    }

    public EzyInstruction valueOf(Class type, String expression, boolean forceCast) {
        Class wrapperType = PRIMITIVE_WRAPPER_TYPES.get(type);
        if (wrapperType != null) {
            return this.clazz(wrapperType).append(".valueOf").brackets(expression);
        }
        if (forceCast) {
            return this.castNormal(type, expression);
        }
        return this.append(expression);
    }

    public EzyInstruction defaultValue(Class type) {
        if (type == Boolean.TYPE) {
            return this.append("false");
        }
        if (type == Byte.TYPE) {
            return this.append("(byte)0");
        }
        if (type == Character.TYPE) {
            return this.append("(char)0");
        }
        if (type == Double.TYPE) {
            return this.append("0D");
        }
        if (type == Float.TYPE) {
            return this.append("0F");
        }
        if (type == Integer.TYPE) {
            return this.append("0");
        }
        if (type == Long.TYPE) {
            return this.append("0L");
        }
        if (type == Short.TYPE) {
            return this.append("(short)0");
        }
        return this.append("null");
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean autoFinish) {
        String string = this.builder.toString();
        if (autoFinish && this.semicolon) {
            string = string.endsWith(";") ? string : string + ";";
        }
        return string + this.end;
    }
}

