/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver;

import com.tvd12.ezyfoxserver.EzyApplication;
import com.tvd12.ezyfoxserver.EzyZoneComponentsStater;
import com.tvd12.ezyfoxserver.context.EzyAppContext;
import com.tvd12.ezyfoxserver.ext.EzyAppEntry;
import com.tvd12.ezyfoxserver.ext.EzyAppEntryLoader;
import com.tvd12.ezyfoxserver.ext.EzyEntryAware;
import com.tvd12.ezyfoxserver.setting.EzyAppSetting;
import java.util.Map;
import java.util.Set;

public class EzyAppsStarter
extends EzyZoneComponentsStater {
    protected final ClassLoader classLoader;
    protected final boolean enableAppClassLoader;
    protected final Map<String, ClassLoader> appClassLoaders;

    protected EzyAppsStarter(Builder builder) {
        super(builder);
        this.classLoader = builder.classLoader;
        this.appClassLoaders = builder.appClassLoaders;
        this.enableAppClassLoader = builder.enableAppClassLoader;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void start() {
        this.startAllApps();
    }

    protected void startAllApps() {
        Set<String> appNames = this.getAppNames();
        this.logger.info("start apps: {}", appNames);
        for (String appName : appNames) {
            this.startApp(appName);
        }
    }

    protected void startApp(String appName) {
        try {
            this.logger.debug("app: {} loading...", (Object)appName);
            EzyAppContext context = this.zoneContext.getAppContext(appName);
            EzyApplication application = context.getApp();
            EzyAppEntry entry = this.startApp(appName, this.newAppEntryLoader(appName));
            ((EzyEntryAware)((Object)application)).setEntry(entry);
            this.logger.debug("app: {} loaded", (Object)appName);
        }
        catch (Exception e) {
            this.logger.error("can not start app: {}", (Object)appName, (Object)e);
        }
    }

    protected EzyAppEntry startApp(String appName, EzyAppEntryLoader loader) throws Exception {
        EzyAppEntry entry = loader.load();
        entry.config(this.getAppContext(appName));
        entry.start();
        return entry;
    }

    protected Set<String> getAppNames() {
        return this.zoneSetting.getAppNames();
    }

    protected EzyAppSetting getAppByName(String name) {
        return this.zoneSetting.getAppByName(name);
    }

    protected Class<EzyAppEntryLoader> getAppEntryLoaderClass(String appName) throws Exception {
        return this.getAppEntryLoaderClass(this.getAppByName(appName));
    }

    protected Class<EzyAppEntryLoader> getAppEntryLoaderClass(EzyAppSetting app) throws Exception {
        ClassLoader classLoader = this.getAppClassLoader(app.getName(), app.getFolder());
        return Class.forName(app.getEntryLoader(), true, classLoader);
    }

    protected EzyAppEntryLoader newAppEntryLoader(String appName) throws Exception {
        Class<EzyAppEntryLoader> entryLoaderClass = this.getAppEntryLoaderClass(appName);
        EzyAppSetting appSetting = this.getAppByName(appName);
        if (appSetting.getEntryLoaderArgs() == null) {
            return entryLoaderClass.newInstance();
        }
        return (EzyAppEntryLoader)entryLoaderClass.getConstructors()[0].newInstance(appSetting.getEntryLoaderArgs());
    }

    protected ClassLoader getAppClassLoader(String appName, String appFolder) {
        ClassLoader appClassLoader = this.appClassLoaders.get(appFolder);
        if (appClassLoader != null) {
            return appClassLoader;
        }
        if (!this.enableAppClassLoader && this.classLoader != null) {
            return this.classLoader;
        }
        throw new IllegalArgumentException("folder: " + appFolder + " for app: " + appName + " doesn't exist");
    }

    protected EzyAppContext getAppContext(String appName) {
        return this.zoneContext.getAppContext(appName);
    }

    public static class Builder
    extends EzyZoneComponentsStater.Builder<EzyAppsStarter, Builder> {
        protected ClassLoader classLoader;
        protected boolean enableAppClassLoader;
        protected Map<String, ClassLoader> appClassLoaders;

        public Builder classLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
            return this;
        }

        public Builder enableAppClassLoader(boolean enableAppClassLoader) {
            this.enableAppClassLoader = enableAppClassLoader;
            return this;
        }

        public Builder appClassLoaders(Map<String, ClassLoader> appClassLoaders) {
            this.appClassLoaders = appClassLoaders;
            return this;
        }

        public EzyAppsStarter build() {
            return new EzyAppsStarter(this);
        }
    }
}

