/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.gamebox.manager;

import com.tvd12.gamebox.entity.Player;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;

public interface PlayerManager<P extends Player> {
    public P getPlayer(String var1);

    public P getPlayer(String var1, Supplier<P> var2);

    public P getFirstPlayer();

    public List<P> getPlayerList();

    public void getPlayerList(List<P> var1);

    public List<P> getPlayerList(Predicate<P> var1);

    public List<String> getPlayerNames();

    public int getPlayerCount();

    public int getMaxPlayer();

    public boolean available();

    public boolean containsPlayer(String var1);

    default public boolean containsPlayer(P player) {
        return this.containsPlayer(((Player)player).getName());
    }

    public void addPlayer(P var1, boolean var2);

    default public void addPlayer(P player) {
        this.addPlayer(player, true);
    }

    public void addPlayers(Collection<P> var1, boolean var2);

    default public void addPlayers(Collection<P> players) {
        this.addPlayers(players, true);
    }

    public P removePlayer(P var1);

    default public P removePlayer(String username) {
        return this.removePlayer(this.getPlayer(username));
    }

    public void removePlayers(Collection<P> var1);

    public void clear();

    public int countPlayers(Predicate<P> var1);

    public void forEach(Consumer<P> var1);

    public List<P> filterPlayers(Predicate<P> var1);

    public boolean isEmpty();
}

