/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.gamebox.math;

import com.tvd12.ezyfox.entity.EzyArray;
import com.tvd12.ezyfox.util.EzyEntityArrays;
import com.tvd12.gamebox.math.Numbers;
import lombok.Generated;

public class Vec2 {
    public float x;
    public float y;
    public static final Vec2 ZERO = new Vec2();
    public static final Vec2 LEFT = new Vec2(-1.0f, 0.0f);
    public static final Vec2 UP = new Vec2(0.0f, 1.0f);
    public static final Vec2 RIGHT = new Vec2(1.0f, 0.0f);
    public static final Vec2 DOWN = new Vec2(0.0f, -1.0f);

    public Vec2() {
        this(0.0f, 0.0f);
    }

    public Vec2(Vec2 v) {
        this.x = v.x;
        this.y = v.y;
    }

    public Vec2(float[] xy) {
        this.x = xy[0];
        this.y = xy[1];
    }

    public Vec2(double x, double y) {
        this.x = (float)x;
        this.y = (float)y;
    }

    public Vec2(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public void set(double[] xy) {
        this.x = (float)xy[0];
        this.y = (float)xy[1];
    }

    public void set(double x, double y) {
        this.x = (float)x;
        this.y = (float)y;
    }

    public void set(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public void set(Vec2 v) {
        this.x = v.x;
        this.y = v.y;
    }

    public void add(Vec2 v) {
        this.x += v.x;
        this.y += v.y;
    }

    public void negate() {
        this.x = -this.x;
        this.y = -this.y;
    }

    public void subtract(Vec2 v) {
        this.x -= v.x;
        this.y -= v.y;
    }

    public void multiply(double a) {
        this.x = (float)((double)this.x * a);
        this.y = (float)((double)this.y * a);
    }

    public Vec2 multipleNew(float a) {
        return new Vec2(this.x * a, this.y * a);
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public double distance(Vec2 v) {
        double dx = v.x - this.x;
        double dy = v.y - this.y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public float distanceSquare(Vec2 v) {
        float dx = this.x - v.x;
        float dy = this.y - v.y;
        return dx * dx + dy * dy;
    }

    public boolean equals(Object obj) {
        Vec2 other = (Vec2)obj;
        return Numbers.equals(this.x, other.x) && Numbers.equals(this.y, other.y);
    }

    public int hashCode() {
        int hashCode = 31 + Float.hashCode(this.x);
        hashCode += 31 * hashCode + Float.hashCode(this.y);
        return hashCode;
    }

    public float[] toFloatArray() {
        return new float[]{this.x, this.y};
    }

    public EzyArray toArray() {
        return EzyEntityArrays.newArray((Object[])new Object[]{Float.valueOf(this.x), Float.valueOf(this.y)});
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ")";
    }

    @Generated
    public float getX() {
        return this.x;
    }

    @Generated
    public float getY() {
        return this.y;
    }
}

