/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.pagination;

import com.tvd12.ezydata.database.query.EzyQueryConditionBuilder;
import com.tvd12.ezyfox.builder.EzyBuilder;
import java.util.Collection;
import org.youngmonkeys.ezyplatform.pagination.ContentTemplateFilter;

public class DefaultContentTemplateFilter
implements ContentTemplateFilter {
    public final String ownerType;
    public final Long ownerId;
    public final String templateType;
    public final String templateName;
    public final String contentType;
    public final Long creatorId;
    public final String status;
    public final Collection<String> keywords;
    public final String likeKeyword;

    protected DefaultContentTemplateFilter(Builder builder) {
        this.ownerType = builder.ownerType;
        this.ownerId = builder.ownerId;
        this.templateType = builder.templateType;
        this.templateName = builder.templateName;
        this.contentType = builder.contentType;
        this.creatorId = builder.creatorId;
        this.status = builder.status;
        this.keywords = builder.keywords;
        this.likeKeyword = builder.likeKeyword;
    }

    public void decorateQueryStringBeforeWhere(StringBuilder queryString) {
        if (this.keywords != null) {
            queryString.append(" INNER JOIN DataIndex k ON e.id = k.dataId");
        }
    }

    public String matchingCondition() {
        EzyQueryConditionBuilder answer = new EzyQueryConditionBuilder();
        if (this.ownerType != null) {
            answer.and("e.ownerType = :ownerType");
        }
        if (this.ownerId != null) {
            answer.and("e.ownerId = :ownerId");
        }
        if (this.templateType != null) {
            answer.and("e.templateType = :templateType");
        }
        if (this.templateName != null) {
            answer.and("e.templateName = :templateName");
        }
        if (this.contentType != null) {
            answer.and("e.contentType = :contentType");
        }
        if (this.creatorId != null) {
            answer.and("e.creatorId = :creatorId");
        }
        if (this.status != null) {
            answer.and("e.status = :status");
        }
        if (this.keywords != null) {
            answer.and("k.dataType = 'ezy_content_templates'").and("k.keyword IN :keywords");
        }
        if (this.likeKeyword != null) {
            answer.and("(e.templateName LIKE CONCAT('%',:likeKeyword,'%') OR e.titleTemplate LIKE CONCAT('%',:likeKeyword,'%') OR e.contentTemplate LIKE CONCAT('%',:likeKeyword,'%'))");
        }
        return answer.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements EzyBuilder<DefaultContentTemplateFilter> {
        protected String ownerType;
        protected Long ownerId;
        protected String templateType;
        protected String templateName;
        protected String contentType;
        protected Long creatorId;
        protected String status;
        protected Collection<String> keywords;
        protected String likeKeyword;

        public Builder ownerType(String ownerType) {
            this.ownerType = ownerType;
            return this;
        }

        public Builder ownerId(Long ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public Builder templateType(String templateType) {
            this.templateType = templateType;
            return this;
        }

        public Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder creatorId(Long creatorId) {
            this.creatorId = creatorId;
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            return this;
        }

        public Builder keywords(Collection<String> keywords) {
            this.keywords = keywords;
            return this;
        }

        public Builder likeKeyword(String likeKeyword) {
            this.likeKeyword = likeKeyword;
            return this;
        }

        public DefaultContentTemplateFilter build() {
            return new DefaultContentTemplateFilter(this);
        }
    }
}

