/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezydata.jpa.loader;

import com.tvd12.ezydata.database.util.EzyDatabasePropertiesKeeper;
import com.tvd12.ezyfox.reflect.EzyReflectionProxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.SharedCacheMode;
import javax.persistence.ValidationMode;
import javax.persistence.spi.ClassTransformer;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.sql.DataSource;
import lombok.Generated;
import org.hibernate.jpa.HibernatePersistenceProvider;

public class EzyJpaEntityManagerFactoryLoader
extends EzyDatabasePropertiesKeeper<EzyJpaEntityManagerFactoryLoader> {
    protected final Set<String> entityPackages = new HashSet<String>();
    protected final List<String> managedClassNames = new ArrayList<String>();
    protected final List<String> mappingFileNames = new ArrayList<String>();
    protected String jpaVersion = "2.2";
    protected DataSource dataSource;
    protected PersistenceUnitTransactionType transactionType = PersistenceUnitTransactionType.RESOURCE_LOCAL;

    public EzyJpaEntityManagerFactoryLoader jpaVersion(String jpaVersion) {
        this.jpaVersion = jpaVersion;
        return this;
    }

    public EzyJpaEntityManagerFactoryLoader dataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    public EzyJpaEntityManagerFactoryLoader transactionType(PersistenceUnitTransactionType transactionType) {
        this.transactionType = transactionType;
        return this;
    }

    public EzyJpaEntityManagerFactoryLoader mappingFileName(String mappingFileName) {
        this.mappingFileNames.add(mappingFileName);
        return this;
    }

    public EzyJpaEntityManagerFactoryLoader mappingFileName(Iterable<String> mappingFileNames) {
        for (String mappingFileName : mappingFileNames) {
            this.mappingFileName(mappingFileName);
        }
        return this;
    }

    public EzyJpaEntityManagerFactoryLoader entityClass(Class<?> entityClass) {
        this.managedClassNames.add(entityClass.getName());
        return this;
    }

    public EzyJpaEntityManagerFactoryLoader entityClasses(Iterable<Class<?>> entityClasses) {
        for (Class<?> entityClass : entityClasses) {
            this.entityClass(entityClass);
        }
        return this;
    }

    public EzyJpaEntityManagerFactoryLoader entityPackage(String entityPackage) {
        this.entityPackages.add(entityPackage);
        return this;
    }

    public EzyJpaEntityManagerFactoryLoader entityPackages(Iterable<String> entityPackages) {
        for (String entityPackage : entityPackages) {
            this.entityPackage(entityPackage);
        }
        return this;
    }

    public EntityManagerFactory load(String persistenceUnitName) {
        this.scanEntityPackages();
        return this.doLoad(persistenceUnitName);
    }

    private EntityManagerFactory doLoad(String persistenceUnitName) {
        EntityManagerFactory entityManagerFactory = null;
        try {
            entityManagerFactory = this.loadByHibernate(persistenceUnitName);
        }
        catch (Throwable e) {
            this.logger.warn("can't load EntityManagerFactory by hibernate (you can disable this warning by config log level to ERROR)", e);
        }
        if (entityManagerFactory == null) {
            entityManagerFactory = this.loadByDefaultJpa(persistenceUnitName);
        }
        return entityManagerFactory;
    }

    private EntityManagerFactory loadByHibernate(String persistenceUnitName) {
        PersistenceUnitInfoImpl persistenceUnitInfo = new PersistenceUnitInfoImpl(persistenceUnitName);
        HibernatePersistenceProvider persistenceProvider = new HibernatePersistenceProvider();
        return persistenceProvider.createContainerEntityManagerFactory((PersistenceUnitInfo)persistenceUnitInfo, Collections.EMPTY_MAP);
    }

    private EntityManagerFactory loadByDefaultJpa(String persistenceUnitName) {
        return Persistence.createEntityManagerFactory((String)persistenceUnitName);
    }

    private void scanEntityPackages() {
        if (this.entityPackages.isEmpty()) {
            return;
        }
        EzyReflectionProxy reflection = new EzyReflectionProxy(this.entityPackages);
        this.entityClasses(reflection.getAnnotatedClasses(Entity.class));
    }

    private class PersistenceUnitInfoImpl
    implements PersistenceUnitInfo {
        private final String persistenceUnitName;

        public String getPersistenceUnitName() {
            return this.persistenceUnitName;
        }

        public String getPersistenceProviderClassName() {
            return HibernatePersistenceProvider.class.getName();
        }

        public PersistenceUnitTransactionType getTransactionType() {
            return EzyJpaEntityManagerFactoryLoader.this.transactionType;
        }

        public DataSource getJtaDataSource() {
            return EzyJpaEntityManagerFactoryLoader.this.dataSource;
        }

        public DataSource getNonJtaDataSource() {
            return EzyJpaEntityManagerFactoryLoader.this.dataSource;
        }

        public List<String> getMappingFileNames() {
            return EzyJpaEntityManagerFactoryLoader.this.mappingFileNames;
        }

        public List<URL> getJarFileUrls() {
            return Collections.emptyList();
        }

        public URL getPersistenceUnitRootUrl() {
            return null;
        }

        public List<String> getManagedClassNames() {
            return EzyJpaEntityManagerFactoryLoader.this.managedClassNames;
        }

        public boolean excludeUnlistedClasses() {
            return false;
        }

        public SharedCacheMode getSharedCacheMode() {
            return SharedCacheMode.UNSPECIFIED;
        }

        public ValidationMode getValidationMode() {
            return ValidationMode.AUTO;
        }

        public Properties getProperties() {
            return EzyJpaEntityManagerFactoryLoader.this.properties;
        }

        public String getPersistenceXMLSchemaVersion() {
            return EzyJpaEntityManagerFactoryLoader.this.jpaVersion;
        }

        public ClassLoader getClassLoader() {
            return Thread.currentThread().getContextClassLoader();
        }

        public void addTransformer(ClassTransformer transformer) {
        }

        public ClassLoader getNewTempClassLoader() {
            return null;
        }

        @Generated
        public PersistenceUnitInfoImpl(String persistenceUnitName) {
            this.persistenceUnitName = persistenceUnitName;
        }
    }
}

