/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.controller.decorator;

import com.tvd12.ezyfox.bean.annotation.EzySingleton;
import com.tvd12.ezyfox.io.EzyLists;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.youngmonkeys.ezyplatform.admin.converter.AdminModelToResponseConverter;
import org.youngmonkeys.ezyplatform.admin.response.AdminInfoResponse;
import org.youngmonkeys.ezyplatform.admin.response.AdminRoleMemberResponse;
import org.youngmonkeys.ezyplatform.admin.service.AdminAdminRoleService;
import org.youngmonkeys.ezyplatform.model.AdminModel;
import org.youngmonkeys.ezyplatform.model.AdminRoleModel;
import org.youngmonkeys.ezyplatform.model.PaginationModel;

@EzySingleton
public class AdminAdminDecorator {
    private final AdminAdminRoleService adminRoleService;
    private final AdminModelToResponseConverter modelToResponseConverter;

    public PaginationModel<AdminInfoResponse> decorateToAdminInfoResponsePagination(PaginationModel<AdminModel> pagination) {
        return pagination.map(this.modelToResponseConverter::toResponse);
    }

    public PaginationModel<AdminRoleMemberResponse> decorateToRoleMemberResponsePagination(PaginationModel<AdminModel> pagination, long roleId) {
        List adminIds = EzyLists.newArrayList((Collection)pagination.getItems(), AdminModel::getId);
        Map<Long, AdminRoleModel> adminRoleMap = this.adminRoleService.getAdminRoleMapByRoleIdAndAdminIds(roleId, adminIds);
        return pagination.map(it -> this.modelToResponseConverter.toAdminRoleMemberResponse((AdminModel)it, (AdminRoleModel)adminRoleMap.get(it.getId())));
    }

    @Generated
    public AdminAdminDecorator(AdminAdminRoleService adminRoleService, AdminModelToResponseConverter modelToResponseConverter) {
        this.adminRoleService = adminRoleService;
        this.modelToResponseConverter = modelToResponseConverter;
    }
}

