/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.controller.decorator;

import com.tvd12.ezyfox.bean.annotation.EzySingleton;
import com.tvd12.ezyfox.io.EzyLists;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.youngmonkeys.ezyplatform.admin.converter.AdminModelToResponseConverter;
import org.youngmonkeys.ezyplatform.admin.response.UserResponse;
import org.youngmonkeys.ezyplatform.admin.response.UserRoleMemberResponse;
import org.youngmonkeys.ezyplatform.admin.service.AdminUserRoleService;
import org.youngmonkeys.ezyplatform.model.PaginationModel;
import org.youngmonkeys.ezyplatform.model.UserModel;
import org.youngmonkeys.ezyplatform.model.UserRoleModel;

@EzySingleton
public class AdminUserDecorator {
    private final AdminUserRoleService userRoleService;
    private final AdminModelToResponseConverter modelToResponseConverter;

    public PaginationModel<UserResponse> decorateToUserResponsePagination(PaginationModel<UserModel> pagination) {
        return pagination.map(this.modelToResponseConverter::toResponse);
    }

    public PaginationModel<UserRoleMemberResponse> decorateToUserRoleMemberResponsePagination(PaginationModel<UserModel> pagination, long roleId) {
        List userIds = EzyLists.newArrayList((Collection)pagination.getItems(), UserModel::getId);
        Map<Long, UserRoleModel> userRoleMap = this.userRoleService.getUserRoleMapByRoleIdAndUserIds(roleId, userIds);
        return pagination.map(it -> this.modelToResponseConverter.toUserRoleMemberResponse((UserModel)it, (UserRoleModel)userRoleMap.get(it.getId())));
    }

    @Generated
    public AdminUserDecorator(AdminUserRoleService userRoleService, AdminModelToResponseConverter modelToResponseConverter) {
        this.userRoleService = userRoleService;
        this.modelToResponseConverter = modelToResponseConverter;
    }
}

