/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.boot.autoconfig;

import com.tvd12.ezyfox.bean.annotation.EzyConfigurationAfter;
import com.tvd12.ezyfox.util.EzyLoggable;
import com.tvd12.ezyhttp.server.core.manager.ComponentManager;
import com.tvd12.ezyhttp.server.core.view.ViewContext;
import com.tvd12.ezyhttp.server.thymeleaf.ThymeleafViewContext;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.thymeleaf.TemplateEngine;
import org.youngmonkeys.devtools.constant.PackageManagerType;
import org.youngmonkeys.devtools.constant.ScopeType;
import org.youngmonkeys.devtools.filewatch.FileWatcher;
import org.youngmonkeys.devtools.util.OS;
import org.youngmonkeys.devtools.util.OSType;

@EzyConfigurationAfter
public class DevToolsConfig
extends EzyLoggable {
    public DevToolsConfig() {
        this(DevToolsConfig.getPackageManagerType());
    }

    public DevToolsConfig(PackageManagerType packageManagerType) {
        this.watchResources(ScopeType.MAIN, packageManagerType);
        this.watchResources(ScopeType.TEST, packageManagerType);
    }

    private static PackageManagerType getPackageManagerType() {
        return new File("pom.xml").exists() ? PackageManagerType.MAVEN : PackageManagerType.GRADLE;
    }

    private void watchResources(ScopeType scopeType, PackageManagerType packageManagerType) {
        Path srcFolder = this.getSourceFolder(scopeType);
        if (!Files.exists(srcFolder, new LinkOption[0])) {
            return;
        }
        Path desFolder = this.getDestinationFolder(scopeType, packageManagerType);
        this.logger.debug("Start watching folder {}", (Object)srcFolder);
        FileWatcher watcher = new FileWatcher(srcFolder, file -> {
            this.logger.debug("FileListener.onFileModified {}", (Object)file);
            try {
                this.clearThymeleafCache();
                this.copyFileToFolder(srcFolder, file, desFolder);
            }
            catch (Exception e) {
                this.logger.error("FileListener.onFileModified error", (Throwable)e);
            }
        });
        watcher.watch();
    }

    private void refreshBrowser() throws IOException {
        this.logger.debug("Refresh Chrome browser");
        if (OS.currentType() == OSType.LINUX) {
            Runtime.getRuntime().exec("xdotool search --onlyvisible --class Chrome windowfocus key ctrl+r");
        } else if (OS.currentType() == OSType.MAC) {
            String[] commands = new String[]{"osascript", "-e", "tell application \"Google Chrome\"\nactivate\ntell application \"System Events\"\ntell process \"Google Chrome\"\nkeystroke \"r\" using {command down, shift down}\nend tell\nend tell\nend tell"};
            Runtime.getRuntime().exec(commands);
        } else if (OS.currentType() == OSType.WINDOWS) {
            this.logger.warn("Auto-reload is not yet supported on Windows");
        } else {
            this.logger.warn("Auto-reload is not yet supported on {}", (Object)OS.currentType());
        }
    }

    private void copyFileToFolder(Path srcFolder, Path from, Path to) throws IOException {
        Files.walk(from, new FileVisitOption[0]).forEach(filePath -> {
            String targetFilePath = filePath.toString().replace(srcFolder.toString(), to.toString());
            if (Files.isRegularFile(filePath, new LinkOption[0])) {
                this.copyFile((Path)filePath, Paths.get(targetFilePath, new String[0]));
            } else {
                this.createFolder(Paths.get(targetFilePath, new String[0]));
            }
        });
    }

    private void copyFile(Path from, Path to) {
        try {
            if (!Files.exists(to.getParent(), new LinkOption[0])) {
                Files.createDirectories(to.getParent(), new FileAttribute[0]);
            }
            Files.copy(from, to, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception e) {
            this.logger.info("can not copy file from: {}, to: {}", new Object[]{from, to, e});
        }
    }

    private void createFolder(Path folder) {
        if (folder != null && !Files.exists(folder, new LinkOption[0])) {
            try {
                Files.createDirectories(folder, new FileAttribute[0]);
            }
            catch (IOException e) {
                this.logger.error("can not create folder: {}", (Object)folder, (Object)e);
            }
        }
    }

    private void clearThymeleafCache() throws NoSuchFieldException, IllegalAccessException {
        ViewContext viewContext = ComponentManager.getInstance().getViewContext();
        if (!(viewContext instanceof ThymeleafViewContext)) {
            return;
        }
        this.logger.debug("Clear cache of thymeleaf");
        Field field = viewContext.getClass().getDeclaredField("templateEngine");
        field.setAccessible(true);
        TemplateEngine templateEngine = (TemplateEngine)field.get(viewContext);
        templateEngine.getConfiguration().getTemplateManager().clearCaches();
    }

    private Path getDestinationFolder(ScopeType scopeType, PackageManagerType packageManagerType) {
        if (packageManagerType == PackageManagerType.MAVEN) {
            return scopeType == ScopeType.MAIN ? Paths.get("target/classes", new String[0]) : Paths.get("target/test-classes", new String[0]);
        }
        if (packageManagerType == PackageManagerType.GRADLE) {
            return scopeType == ScopeType.MAIN ? Paths.get("build/resources/main", new String[0]) : Paths.get("build/resources/test", new String[0]);
        }
        throw new IllegalArgumentException();
    }

    private Path getSourceFolder(ScopeType scopeType) {
        return scopeType == ScopeType.MAIN ? Paths.get("src/main/resources", new String[0]) : Paths.get("src/test/resources", new String[0]);
    }
}

