/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.devtools.swagger;

import com.tvd12.ezyfox.annotation.EzyFeature;
import com.tvd12.ezyfox.collect.Sets;
import com.tvd12.ezyfox.file.EzySimpleFileWriter;
import com.tvd12.ezyfox.io.EzyCollections;
import com.tvd12.ezyfox.io.EzyLists;
import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyfox.reflect.EzyGenerics;
import com.tvd12.ezyfox.reflect.EzyMethods;
import com.tvd12.ezyfox.reflect.EzyReflectionProxy;
import com.tvd12.ezyfox.reflect.EzyTypes;
import com.tvd12.ezyfox.util.EzyFileUtil;
import com.tvd12.ezyfox.util.EzyMapBuilder;
import com.tvd12.ezyhttp.core.response.ResponseEntity;
import com.tvd12.ezyhttp.server.core.annotation.Api;
import com.tvd12.ezyhttp.server.core.annotation.Authenticated;
import com.tvd12.ezyhttp.server.core.annotation.Controller;
import com.tvd12.ezyhttp.server.core.annotation.DoDelete;
import com.tvd12.ezyhttp.server.core.annotation.DoGet;
import com.tvd12.ezyhttp.server.core.annotation.DoPost;
import com.tvd12.ezyhttp.server.core.annotation.DoPut;
import com.tvd12.ezyhttp.server.core.annotation.PathVariable;
import com.tvd12.ezyhttp.server.core.annotation.RequestBody;
import com.tvd12.ezyhttp.server.core.annotation.RequestParam;
import com.tvd12.ezyhttp.server.core.view.Redirect;
import com.tvd12.ezyhttp.server.core.view.View;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;

public class SwaggerGenerator {
    private final String packageToScan;
    private static final int ONE = 1;
    private static final int TWO = 2;
    private static final int THREE = 3;
    private static final String PREFIX_SET = "set";
    private static final String PREFIX_GET = "get";
    private static final Class<?> NO_GENERICS_TYPE = null;
    private static final List<ApiDataField> NO_FIELDS = null;
    private static final Set<String> NO_CONTENT_JAVA_TYPES = Sets.newHashSet((Object[])new String[]{"redirect", "response_entity", "void"});
    private static final Map<String, String> CONTENT_TYPE_BY_JAVA_TYPE_NAME = EzyMapBuilder.mapBuilder().put((Object)"view", (Object)"text/html").toMap();
    private static final Map<String, String> SWAGGER_TYPE_BY_JAVA_TYPE_NAME = EzyMapBuilder.mapBuilder().put((Object)"double", (Object)"number").put((Object)"float", (Object)"number").put((Object)"long", (Object)"number").put((Object)"view", (Object)"string").toMap();
    private static final Map<String, String> SWAGGER_FORMAT_BY_JAVA_TYPE_NAME = EzyMapBuilder.mapBuilder().put((Object)"double", (Object)"number").put((Object)"float", (Object)"float").put((Object)"integer", (Object)"int32").put((Object)"long", (Object)"int64").toMap();

    public void generateToDefaultFile() throws IOException {
        this.generateToFile("swagger.yaml");
    }

    public void generateToFile(String filePath) throws IOException {
        File file = new File(filePath);
        EzyFileUtil.createFileIfNotExists((File)file);
        new EzySimpleFileWriter().write(file, (CharSequence)this.generate(), StandardCharsets.UTF_8.toString());
        System.out.println("generated to: " + filePath);
    }

    private Map<Class<?>, String> getTypeByJavaClass() {
        return Collections.emptyMap();
    }

    public String generate() {
        EzyReflectionProxy reflection = new EzyReflectionProxy(this.packageToScan);
        Set controllerClasses = reflection.getAnnotatedClasses(Controller.class);
        return this.generate(controllerClasses);
    }

    public String generate(Collection<Class<?>> controllerClasses) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("openapi: 3.0.2");
        lines.add("info:");
        lines.add(this.appendDoubleSpacesToLine("title: EzyPlatform APIs", 1));
        lines.add(this.appendDoubleSpacesToLine("version: 1.0.0", 1));
        lines.add("servers:");
        lines.addAll(this.appendDoubleSpacesToLines(this.createServers(), 1));
        lines.add("paths:");
        lines.addAll(this.appendDoubleSpacesToLines(this.createApis(controllerClasses), 1));
        return this.joinLine(lines);
    }

    private List<String> createServers() {
        return this.getServers().stream().flatMap(it -> this.createServer((Map<String, Object>)it).stream()).collect(Collectors.toList());
    }

    private List<String> createServer(Map<String, Object> server) {
        return Arrays.asList("- url: " + server.get("url"), "  description: " + server.get("description"));
    }

    protected List<Map<String, Object>> getServers() {
        return Collections.singletonList(EzyMapBuilder.mapBuilder().put((Object)"url", (Object)"http://localhost:8080").put((Object)"description", (Object)"localhost").toMap());
    }

    private List<String> createApis(Collection<Class<?>> controllerClasses) {
        List apiClasses = EzyLists.newArrayList(controllerClasses, this::extractControllerClass);
        HashSet<ApiMethod> generatedMethods = new HashSet<ApiMethod>();
        ArrayList<String> apis = new ArrayList<String>();
        for (ApiClass apiClass : apiClasses) {
            for (String uri : apiClass.methodsByUri.keySet()) {
                List apiMethods = EzyLists.filter((Collection)((Collection)apiClass.methodsByUri.get(uri)), it -> !generatedMethods.contains(it));
                for (int i = 0; i < apiMethods.size(); ++i) {
                    ApiMethod apiMethod = (ApiMethod)apiMethods.get(i);
                    generatedMethods.add(apiMethod);
                    if (i == 0) {
                        apis.add("'" + uri + "':");
                    }
                    apis.addAll(this.createApi(apiMethod));
                }
            }
        }
        return apis;
    }

    private List<String> createApi(ApiMethod apiMethod) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(this.appendDoubleSpacesToLine(apiMethod.type + ":", 1));
        lines.add(this.appendDoubleSpacesToLine("summary: >", 2));
        lines.add(this.appendDoubleSpacesToLine(this.toFriendlyText(apiMethod.name), 3));
        lines.add(this.appendDoubleSpacesToLine("description: >", 2));
        lines.addAll(this.appendDoubleSpacesToLines(this.createApiDescription(apiMethod), 3));
        lines.addAll(this.appendDoubleSpacesToLines(this.createApiRequestBody(apiMethod), 2));
        lines.addAll(this.appendDoubleSpacesToLines(this.createApiParameters(apiMethod.parameters), 2));
        lines.add(this.appendDoubleSpacesToLine("responses:", 2));
        lines.addAll(this.appendDoubleSpacesToLines(this.createApiResponseBody(apiMethod), 3));
        return lines;
    }

    private List<String> createApiDescription(ApiMethod apiMethod) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("- feature: " + this.toFriendlyText(apiMethod.feature));
        lines.add("- api: " + (apiMethod.api ? "yes" : "no"));
        lines.add("- authenticated: " + (apiMethod.authenticated ? "yes" : "no"));
        return lines;
    }

    private List<String> createApiRequestBody(ApiMethod apiMethod) {
        ApiDataType requestBody = apiMethod.requestBody;
        if (requestBody == null) {
            return Collections.emptyList();
        }
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("requestBody: ");
        lines.add(this.appendDoubleSpacesToLine("required: true", 1));
        lines.add(this.appendDoubleSpacesToLine("content:", 1));
        lines.addAll(this.appendDoubleSpacesToLines(this.convertApiDataToContent(requestBody, PREFIX_SET), 2));
        return lines;
    }

    private List<String> createApiParameters(List<ApiParameter> apiParameters) {
        if (apiParameters.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("parameters:");
        List<String> parameters = apiParameters.stream().flatMap(it -> this.createApiParameter((ApiParameter)it).stream()).collect(Collectors.toList());
        lines.addAll(this.appendDoubleSpacesToLines(parameters, 1));
        return lines;
    }

    private List<String> createApiParameter(ApiParameter apiParameter) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("- name: " + apiParameter.name);
        lines.add("  in: " + apiParameter.in);
        String description = apiParameter.defaultValue != null ? "default value is " + apiParameter.defaultValue : "parameter";
        lines.add("  description: " + description);
        lines.add("  required: " + "path".equals(apiParameter.in));
        lines.addAll(this.appendDoubleSpacesToLines(this.convertApiDataTypeToSchema(apiParameter.apiDataType, PREFIX_SET), 1));
        return lines;
    }

    private List<String> createApiResponseBody(ApiMethod apiMethod) {
        String code = "200";
        String description = "success";
        ApiDataType response = apiMethod.response;
        if (response.type == Redirect.class) {
            code = "302";
            description = "redirect";
        } else if (response.type == ResponseEntity.class) {
            code = "204";
            description = "no content";
        } else if (response.type == View.class) {
            description = "return a view";
        }
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("'" + code + "':");
        lines.add(this.appendDoubleSpacesToLine("description: >", 1));
        lines.add(this.appendDoubleSpacesToLine(description, 2));
        String javaType = response.javaType;
        if (!NO_CONTENT_JAVA_TYPES.contains(javaType)) {
            lines.add(this.appendDoubleSpacesToLine("content:", 1));
            lines.addAll(this.appendDoubleSpacesToLines(this.convertApiDataToContent(response, PREFIX_GET), 2));
        }
        return lines;
    }

    private List<String> convertApiDataToContent(ApiDataType apiDataType, String methodPrefix) {
        ArrayList<String> lines = new ArrayList<String>();
        String contentType = CONTENT_TYPE_BY_JAVA_TYPE_NAME.getOrDefault(apiDataType.javaType, "application/json");
        lines.add(contentType + ":");
        lines.addAll(this.appendDoubleSpacesToLines(this.convertApiDataTypeToSchema(apiDataType, methodPrefix), 1));
        return lines;
    }

    private List<String> convertApiDataTypeToSchema(ApiDataType apiDataType, String methodPrefix) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("schema:");
        String javaType = apiDataType.javaType;
        lines.addAll(this.appendDoubleSpacesToLines(this.createTypeFormat(javaType), 1));
        lines.addAll(this.appendDoubleSpacesToLines(this.createProperties(apiDataType, methodPrefix, new HashMap()), 1));
        return lines;
    }

    private List<String> createTypeFormat(String javaType) {
        ArrayList<String> lines = new ArrayList<String>();
        String swaggerType = SWAGGER_TYPE_BY_JAVA_TYPE_NAME.getOrDefault(javaType, javaType);
        lines.add("type: " + swaggerType);
        String swaggerFormat = SWAGGER_FORMAT_BY_JAVA_TYPE_NAME.get(javaType);
        if (swaggerFormat != null) {
            lines.add("format: " + swaggerFormat);
        }
        return lines;
    }

    private List<String> createProperties(ApiDataType apiDataType, String methodPrefix, Map<Class<?>, Set<Class<?>>> dependenciesByType) {
        String javaType = apiDataType.javaType;
        if ("object".equals(javaType)) {
            return this.createObjectProperties(apiDataType.fields, methodPrefix, dependenciesByType);
        }
        if ("array".equals(javaType)) {
            return this.createItems(apiDataType.genericsType, methodPrefix, dependenciesByType);
        }
        return Collections.emptyList();
    }

    private List<String> createObjectProperties(List<ApiDataField> fields, String methodPrefix, Map<Class<?>, Set<Class<?>>> dependenciesByType) {
        if (EzyCollections.isEmpty(fields)) {
            return Collections.emptyList();
        }
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("properties:");
        for (ApiDataField field : fields) {
            lines.addAll(this.appendDoubleSpacesToLines(this.createFieldProperties(field, methodPrefix, dependenciesByType), 1));
        }
        return lines;
    }

    private List<String> createFieldProperties(ApiDataField field, String methodPrefix, Map<Class<?>, Set<Class<?>>> dependenciesByType) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(field.name + ":");
        String fieldJavaType = this.mapJavaType(field.javaType);
        lines.addAll(this.appendDoubleSpacesToLines(this.createTypeFormat(fieldJavaType), 1));
        if ("array".equals(fieldJavaType)) {
            Set dependencies;
            Class<?> fieldGenericsType = this.getGenericType(field.javaGenericsType);
            if (fieldGenericsType == null) {
                fieldGenericsType = field.javaType.getComponentType();
            }
            if ((dependencies = dependenciesByType.computeIfAbsent(fieldGenericsType, k -> new HashSet())).contains(fieldGenericsType)) {
                lines.add(this.appendDoubleSpacesToLine("items:", 1));
                lines.add(this.appendDoubleSpacesToLine("type: object", 2));
                return lines;
            }
            dependencies.add(fieldGenericsType);
            lines.addAll(this.appendDoubleSpacesToLines(this.createItems(fieldGenericsType, methodPrefix, dependenciesByType), 1));
        } else if ("object".equals(fieldJavaType)) {
            Set dependencies = dependenciesByType.computeIfAbsent(field.javaType, k -> new HashSet());
            if (dependencies.contains(field.javaType)) {
                return lines;
            }
            dependencies.add(field.javaType);
            lines.addAll(this.appendDoubleSpacesToLines(this.createProperties(new ApiDataType(fieldJavaType, field.javaType, NO_GENERICS_TYPE, this.extractApiDataFields(field.javaType, methodPrefix)), methodPrefix, dependenciesByType), 1));
        }
        return lines;
    }

    private List<String> createItems(Class<?> genericsType, String methodPrefix, Map<Class<?>, Set<Class<?>>> dependenciesByType) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("items:");
        String genericsTypeName = genericsType == null ? "object" : (EzyTypes.NON_ARRAY_TYPES.contains(genericsType) ? genericsType.getSimpleName().toLowerCase() : (Collection.class.isAssignableFrom(genericsType) ? "array" : "object"));
        lines.addAll(this.appendDoubleSpacesToLines(this.createTypeFormat(genericsTypeName), 1));
        if ("object".equals(genericsTypeName)) {
            lines.addAll(this.appendDoubleSpacesToLines(this.createProperties(new ApiDataType(genericsTypeName, genericsType, NO_GENERICS_TYPE, this.extractApiDataFields(genericsType, methodPrefix)), methodPrefix, dependenciesByType), 1));
        } else if ("array".equals(genericsTypeName)) {
            lines.addAll(this.appendDoubleSpacesToLines(this.createItems(NO_GENERICS_TYPE, methodPrefix, dependenciesByType), 1));
        }
        return lines;
    }

    private ApiClass extractControllerClass(Class<?> controllerClass) {
        Api apiAnnotation = controllerClass.getAnnotation(Api.class);
        Controller controllerAnnotation = controllerClass.getAnnotation(Controller.class);
        Authenticated authenticatedAnnotation = controllerClass.getAnnotation(Authenticated.class);
        EzyFeature featureAnnotation = controllerClass.getAnnotation(EzyFeature.class);
        String uri = null;
        if (controllerAnnotation != null && EzyStrings.isBlank((String)(uri = controllerAnnotation.uri()))) {
            uri = controllerAnnotation.value();
        }
        if (EzyStrings.isBlank(uri)) {
            uri = "/";
        }
        String feature = featureAnnotation == null ? "" : featureAnnotation.value();
        String finalUri = uri;
        List methods = EzyMethods.getMethods(controllerClass).stream().filter(it -> it.isAnnotationPresent(DoDelete.class) || it.isAnnotationPresent(DoGet.class) || it.isAnnotationPresent(DoPost.class) || it.isAnnotationPresent(DoPut.class)).map(it -> this.extractControllerMethod((Method)it, apiAnnotation != null, authenticatedAnnotation != null, finalUri, feature)).collect(Collectors.toList());
        return new ApiClass(methods.stream().collect(Collectors.groupingBy(it -> ((ApiMethod)it).uri, Collectors.toList())));
    }

    private ApiMethod extractControllerMethod(Method method, boolean parentIsApi, boolean parentIsAuthenticated, String parentUri, String parentFeature) {
        String uri;
        String type;
        DoDelete doDelete = method.getAnnotation(DoDelete.class);
        DoGet doGet = method.getAnnotation(DoGet.class);
        DoPost doPost = method.getAnnotation(DoPost.class);
        DoPut doPut = method.getAnnotation(DoPut.class);
        if (doDelete != null) {
            type = "delete";
            uri = doDelete.uri();
            if (EzyStrings.isBlank((String)uri)) {
                uri = doDelete.value();
            }
        } else if (doGet != null) {
            type = PREFIX_GET;
            uri = doGet.uri();
            if (EzyStrings.isBlank((String)uri)) {
                uri = doGet.value();
            }
        } else if (doPost != null) {
            type = "post";
            uri = doPost.uri();
            if (EzyStrings.isBlank((String)uri)) {
                uri = doPost.value();
            }
        } else {
            type = "put";
            uri = doPut.uri();
            if (EzyStrings.isBlank((String)uri)) {
                uri = doPut.value();
            }
        }
        String fullUri = parentUri;
        if (EzyStrings.isNotBlank((String)uri)) {
            fullUri = (parentUri + uri).replace("//", "/");
        }
        EzyFeature feature = method.getAnnotation(EzyFeature.class);
        Api api = method.getAnnotation(Api.class);
        Authenticated authenticated = method.getAnnotation(Authenticated.class);
        return new ApiMethod(method.getName(), type, fullUri, feature != null ? feature.value() : parentFeature, authenticated != null || parentIsAuthenticated, api != null || parentIsApi, this.extractParameters(fullUri, method), this.extractRequestBody(method), this.extractResponse(method));
    }

    private List<ApiParameter> extractParameters(String uri, Method method) {
        int index;
        ArrayList<String> pathVariables = new ArrayList<String>();
        String uriRemain = uri;
        while ((index = uriRemain.indexOf(123)) > 0 && (index = (uriRemain = uriRemain.substring(index + 1)).indexOf(125)) > 0) {
            pathVariables.add(uriRemain.substring(0, index));
            if (index >= uriRemain.length() - 1) break;
            uriRemain = uriRemain.substring(index + 1);
        }
        int pathVariableIndex = 0;
        ArrayList<ApiParameter> answer = new ArrayList<ApiParameter>();
        for (Parameter parameter : method.getParameters()) {
            RequestParam requestParamAnnotation;
            String name = null;
            String defaultValue = null;
            String in = null;
            PathVariable pathVariableAnnotation = parameter.getAnnotation(PathVariable.class);
            if (pathVariableAnnotation != null) {
                in = "path";
                name = pathVariableAnnotation.value();
                if (EzyStrings.isBlank((String)name)) {
                    name = pathVariableIndex < pathVariables.size() ? (String)pathVariables.get(pathVariableIndex) : "unknown";
                }
                ++pathVariableIndex;
            }
            if ((requestParamAnnotation = parameter.getAnnotation(RequestParam.class)) != null) {
                in = "query";
                name = requestParamAnnotation.value();
                if (EzyStrings.isBlank((String)name)) {
                    name = parameter.getName();
                }
                defaultValue = requestParamAnnotation.defaultValue();
            }
            if (in == null) continue;
            answer.add(new ApiParameter(in, name, defaultValue, this.createApiDataType(parameter.getType(), this.getGenericType(parameter.getParameterizedType()), PREFIX_SET)));
        }
        return answer;
    }

    private ApiDataType extractRequestBody(Method method) {
        Parameter requestBodyParam = null;
        for (Parameter parameter : method.getParameters()) {
            if (!parameter.isAnnotationPresent(RequestBody.class)) continue;
            requestBodyParam = parameter;
            break;
        }
        if (requestBodyParam == null) {
            return null;
        }
        return this.createApiDataType(requestBodyParam.getType(), requestBodyParam.getParameterizedType(), PREFIX_SET);
    }

    private ApiDataType extractResponse(Method method) {
        return this.createApiDataType(method.getReturnType(), method.getGenericReturnType(), PREFIX_GET);
    }

    private ApiDataType createApiDataType(Class<?> type, Type genericsParameterizedType, String methodPrefix) {
        String javaType = this.mapJavaType(type);
        List<ApiDataField> fields = NO_FIELDS;
        if ("object".equals(javaType)) {
            fields = this.extractApiDataFields(type, methodPrefix);
        }
        return new ApiDataType(javaType, type, this.getGenericType(genericsParameterizedType), fields);
    }

    private List<ApiDataField> extractApiDataFields(Class<?> clazz, String methodPrefix) {
        if (clazz == null) {
            return Collections.emptyList();
        }
        boolean isSetter = PREFIX_SET.equals(methodPrefix);
        return EzyMethods.getPublicMethods(clazz).stream().filter(it -> (it.getName().startsWith(methodPrefix) || it.getName().startsWith("is")) && (isSetter ? it.getParameterCount() == 1 : it.getParameterCount() == 0)).map(it -> new ApiDataField(isSetter ? EzyMethods.getFieldNameOfSetter((Method)it) : EzyMethods.getFieldNameOfGetter((Method)it), isSetter ? it.getParameterTypes()[0] : it.getReturnType(), isSetter ? it.getGenericParameterTypes()[0] : it.getGenericReturnType())).distinct().sorted(Comparator.comparing(a -> ((ApiDataField)a).name)).collect(Collectors.toList());
    }

    private Class<?> getGenericType(Type type) {
        try {
            return EzyGenerics.getOneGenericClassArgument((Type)type);
        }
        catch (Exception e) {
            return null;
        }
    }

    private String appendDoubleSpacesToLine(String line, int doubleSpaces) {
        String spacesString = this.createSpaces(doubleSpaces);
        return spacesString + line;
    }

    private List<String> appendDoubleSpacesToLines(List<String> lines, int doubleSpaces) {
        String spacesString = this.createSpaces(doubleSpaces);
        return lines.stream().filter(EzyStrings::isNotBlank).filter(it -> !it.trim().equals("'':")).map(it -> spacesString + it).collect(Collectors.toList());
    }

    private String createSpaces(int doubleSpaces) {
        return EzyStrings.newString((char)' ', (int)(doubleSpaces * 2));
    }

    private String joinLine(Collection<String> lines) {
        return String.join((CharSequence)"\n", lines);
    }

    private String mapJavaType(Class<?> javaType) {
        if (javaType == null) {
            return "object";
        }
        Map<Class<?>, String> typeByJavaClass = this.getTypeByJavaClass();
        String type = typeByJavaClass.get(javaType);
        if (type != null) {
            return type;
        }
        type = javaType == Void.TYPE ? "void" : (javaType == Redirect.class ? "redirect" : (javaType == ResponseEntity.class ? "response_entity" : (javaType == View.class ? "view" : (javaType == LocalDateTime.class ? "string" : (javaType == LocalDate.class ? "string" : (javaType.isEnum() ? "string" : (javaType == BigInteger.class ? "integer" : (javaType == BigDecimal.class ? "double" : (EzyTypes.NON_ARRAY_TYPES.contains(javaType) ? (javaType == Boolean.TYPE || javaType == Boolean.class ? "boolean" : (javaType == Integer.TYPE || javaType == Integer.class || javaType == Byte.TYPE || javaType == Byte.class || javaType == Short.TYPE || javaType == Short.class ? "integer" : (javaType == Long.TYPE || javaType == Long.class ? "long" : (javaType == Float.TYPE || javaType == Float.class ? "float" : (javaType == Double.TYPE || javaType == Double.class ? "double" : "string"))))) : (javaType.isArray() ? "array" : (Collection.class.isAssignableFrom(javaType) ? "array" : "object")))))))))));
        return type;
    }

    private String toFriendlyText(String s) {
        if (EzyStrings.isBlank((String)s)) {
            return s;
        }
        String withSpaces = s.replaceAll("[^\\p{L}\\p{Nd}]+", " ").replaceAll("([\\p{Ll}\\p{Nd}])(\\p{Lu})", "$1 $2").replaceAll("(\\p{Lu}+)(\\p{Lu}\\p{Ll})", "$1 $2").replaceAll("(\\p{L})(\\p{Nd})", "$1 $2").replaceAll("(\\p{Nd})(\\p{L})", "$1 $2").trim().replaceAll("\\s+", " ");
        String lower = Arrays.stream(withSpaces.split("\\s+")).map(String::toLowerCase).collect(Collectors.joining(" "));
        return lower.isEmpty() ? lower : Character.toUpperCase(lower.charAt(0)) + lower.substring(1);
    }

    @Generated
    public SwaggerGenerator(String packageToScan) {
        this.packageToScan = packageToScan;
    }

    private static class ApiParameter {
        private String in;
        private final String name;
        private final String defaultValue;
        private final ApiDataType apiDataType;

        @Generated
        public ApiParameter(String in, String name, String defaultValue, ApiDataType apiDataType) {
            this.in = in;
            this.name = name;
            this.defaultValue = defaultValue;
            this.apiDataType = apiDataType;
        }
    }

    private static class ApiDataField {
        private final String name;
        private final Class<?> javaType;
        private final Type javaGenericsType;

        @Generated
        public ApiDataField(String name, Class<?> javaType, Type javaGenericsType) {
            this.name = name;
            this.javaType = javaType;
            this.javaGenericsType = javaGenericsType;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ApiDataField)) {
                return false;
            }
            ApiDataField other = (ApiDataField)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.name;
            String other$name = other.name;
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ApiDataField;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.name;
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }
    }

    private static class ApiDataType {
        private final String javaType;
        private final Class<?> type;
        private final Class<?> genericsType;
        private final List<ApiDataField> fields;

        @Generated
        public ApiDataType(String javaType, Class<?> type, Class<?> genericsType, List<ApiDataField> fields) {
            this.javaType = javaType;
            this.type = type;
            this.genericsType = genericsType;
            this.fields = fields;
        }
    }

    public static class ApiMethod {
        private final String name;
        private final String type;
        private final String uri;
        private final String feature;
        private final boolean api;
        private final boolean authenticated;
        private final List<ApiParameter> parameters;
        private final ApiDataType requestBody;
        private final ApiDataType response;

        @Generated
        public ApiMethod(String name, String type, String uri, String feature, boolean api, boolean authenticated, List<ApiParameter> parameters, ApiDataType requestBody, ApiDataType response) {
            this.name = name;
            this.type = type;
            this.uri = uri;
            this.feature = feature;
            this.api = api;
            this.authenticated = authenticated;
            this.parameters = parameters;
            this.requestBody = requestBody;
            this.response = response;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ApiMethod)) {
                return false;
            }
            ApiMethod other = (ApiMethod)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$type = this.type;
            String other$type = other.type;
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$uri = this.uri;
            String other$uri = other.uri;
            return !(this$uri == null ? other$uri != null : !this$uri.equals(other$uri));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ApiMethod;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $type = this.type;
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $uri = this.uri;
            result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
            return result;
        }
    }

    public static class ApiClass {
        private final Map<String, List<ApiMethod>> methodsByUri;

        @Generated
        public ApiClass(Map<String, List<ApiMethod>> methodsByUri) {
            this.methodsByUri = methodsByUri;
        }
    }
}

