/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyhttp.server.core.manager;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.tvd12.ezyfox.util.EzyDestroyable;
import com.tvd12.ezyhttp.core.codec.DataConverters;
import com.tvd12.ezyhttp.core.json.ObjectMapperBuilder;
import com.tvd12.ezyhttp.server.core.handler.RequestResponseWatcher;
import com.tvd12.ezyhttp.server.core.handler.UnhandledErrorHandler;
import com.tvd12.ezyhttp.server.core.manager.ControllerManager;
import com.tvd12.ezyhttp.server.core.manager.ExceptionHandlerManager;
import com.tvd12.ezyhttp.server.core.manager.InterceptorManager;
import com.tvd12.ezyhttp.server.core.manager.RequestHandlerManager;
import com.tvd12.ezyhttp.server.core.view.ViewContext;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

public final class ComponentManager
implements EzyDestroyable {
    private boolean debug;
    private int serverPort;
    private int managementPort;
    private boolean exposeManagementURIs;
    private int asyncDefaultTimeout;
    private ViewContext viewContext;
    private final ObjectMapper objectMapper = new ObjectMapperBuilder().build();
    private final DataConverters dataConverters = new DataConverters(this.objectMapper);
    private UnhandledErrorHandler unhandledErrorHandler;
    private final ControllerManager controllerManager;
    private final InterceptorManager interceptorManager;
    private final RequestHandlerManager requestHandlerManager;
    private final ExceptionHandlerManager exceptionHandlerManager;
    private final List<RequestResponseWatcher> requestResponseWatchers = new ArrayList<RequestResponseWatcher>();
    private static final ComponentManager INSTANCE = new ComponentManager();

    private ComponentManager() {
        this.controllerManager = new ControllerManager();
        this.interceptorManager = new InterceptorManager();
        this.requestHandlerManager = new RequestHandlerManager();
        this.exceptionHandlerManager = new ExceptionHandlerManager();
    }

    public static ComponentManager getInstance() {
        return INSTANCE;
    }

    public void setUnhandledErrorHandler(List<UnhandledErrorHandler> handlers) {
        if (!handlers.isEmpty()) {
            this.unhandledErrorHandler = handlers.get(0);
        }
    }

    public void addRequestResponseWatchers(List<RequestResponseWatcher> watchers) {
        this.requestResponseWatchers.addAll(watchers);
    }

    public void destroy() {
        this.viewContext = null;
        this.exposeManagementURIs = false;
        this.unhandledErrorHandler = null;
        this.dataConverters.destroy();
        this.controllerManager.destroy();
        this.interceptorManager.destroy();
        this.requestHandlerManager.destroy();
        this.exceptionHandlerManager.destroy();
        this.requestResponseWatchers.clear();
    }

    @Generated
    public boolean isDebug() {
        return this.debug;
    }

    @Generated
    public int getServerPort() {
        return this.serverPort;
    }

    @Generated
    public int getManagementPort() {
        return this.managementPort;
    }

    @Generated
    public boolean isExposeManagementURIs() {
        return this.exposeManagementURIs;
    }

    @Generated
    public int getAsyncDefaultTimeout() {
        return this.asyncDefaultTimeout;
    }

    @Generated
    public ViewContext getViewContext() {
        return this.viewContext;
    }

    @Generated
    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @Generated
    public DataConverters getDataConverters() {
        return this.dataConverters;
    }

    @Generated
    public UnhandledErrorHandler getUnhandledErrorHandler() {
        return this.unhandledErrorHandler;
    }

    @Generated
    public ControllerManager getControllerManager() {
        return this.controllerManager;
    }

    @Generated
    public InterceptorManager getInterceptorManager() {
        return this.interceptorManager;
    }

    @Generated
    public RequestHandlerManager getRequestHandlerManager() {
        return this.requestHandlerManager;
    }

    @Generated
    public ExceptionHandlerManager getExceptionHandlerManager() {
        return this.exceptionHandlerManager;
    }

    @Generated
    public List<RequestResponseWatcher> getRequestResponseWatchers() {
        return this.requestResponseWatchers;
    }

    @Generated
    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    @Generated
    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    @Generated
    public void setManagementPort(int managementPort) {
        this.managementPort = managementPort;
    }

    @Generated
    public void setExposeManagementURIs(boolean exposeManagementURIs) {
        this.exposeManagementURIs = exposeManagementURIs;
    }

    @Generated
    public void setAsyncDefaultTimeout(int asyncDefaultTimeout) {
        this.asyncDefaultTimeout = asyncDefaultTimeout;
    }

    @Generated
    public void setViewContext(ViewContext viewContext) {
        this.viewContext = viewContext;
    }
}

