/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.socket.controller;

import com.tvd12.ezyfox.bean.annotation.EzySingleton;
import com.tvd12.ezyfox.core.annotation.EzyEventHandler;
import com.tvd12.ezyfox.entity.EzyData;
import com.tvd12.ezyfox.entity.EzyObject;
import com.tvd12.ezyfox.factory.EzyEntityFactory;
import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyfoxserver.constant.EzyILoginError;
import com.tvd12.ezyfoxserver.constant.EzyLoginError;
import com.tvd12.ezyfoxserver.context.EzyPluginContext;
import com.tvd12.ezyfoxserver.controller.EzyAbstractPluginEventController;
import com.tvd12.ezyfoxserver.event.EzyUserLoginEvent;
import com.tvd12.ezyfoxserver.exception.EzyLoginErrorException;
import com.tvd12.ezyfoxserver.setting.EzyUserManagementSetting;
import lombok.Generated;
import org.youngmonkeys.ezyplatform.constant.ISocketUserType;
import org.youngmonkeys.ezyplatform.constant.SocketUserType;
import org.youngmonkeys.ezyplatform.exception.AdminInvalidAccessTokenException;
import org.youngmonkeys.ezyplatform.exception.UserInvalidAccessTokenException;
import org.youngmonkeys.ezyplatform.model.AdminModel;
import org.youngmonkeys.ezyplatform.model.UserModel;
import org.youngmonkeys.ezyplatform.socket.data.SocketLoginData;
import org.youngmonkeys.ezyplatform.socket.data.SocketUserData;
import org.youngmonkeys.ezyplatform.socket.event.EzyUserLoginEvents;
import org.youngmonkeys.ezyplatform.socket.service.SocketAdminService;
import org.youngmonkeys.ezyplatform.socket.service.SocketUserService;

@EzySingleton
@EzyEventHandler(event="USER_LOGIN", priority=0x7FFFFFFF)
public class SocketLoginController
extends EzyAbstractPluginEventController<EzyUserLoginEvent> {
    private final SocketAdminService adminService;
    private final SocketUserService userService;

    public void handle(EzyPluginContext context, EzyUserLoginEvent event) {
        if (EzyUserLoginEvents.isAuthenticated((EzyUserLoginEvent)event)) {
            this.doOnAuthenticated(context, event);
        } else {
            this.authenticate(context, event);
        }
    }

    protected void doOnAuthenticated(EzyPluginContext context, EzyUserLoginEvent event) {
        this.logger.info("user has already authenticated");
    }

    protected void authenticate(EzyPluginContext context, EzyUserLoginEvent event) {
        try {
            this.logger.info("authenticating user ...");
            SocketLoginData data = EzyUserLoginEvents.getLoginData((EzyUserLoginEvent)event);
            String userAccessToken = data.getUserAccessToken();
            String adminAccessToken = data.getAdminAccessToken();
            SocketUserData socketUserData = EzyStrings.isNotBlank((String)userAccessToken) ? this.handleUserLogin(event, userAccessToken) : (EzyStrings.isNotBlank((String)adminAccessToken) ? this.handleAdminLogin(event, adminAccessToken) : this.doOnMissingAccessToken(context, event));
            event.setUserProperty(SocketUserData.class, (Object)socketUserData);
            EzyData output = event.getOutput();
            if (output == null) {
                output = EzyEntityFactory.newObject();
                event.setOutput(output);
            }
            if (output instanceof EzyObject) {
                EzyObject outputObject = (EzyObject)output;
                outputObject.put((Object)"socketUserType", (Object)socketUserData.getSocketUserType());
                outputObject.put((Object)"socketUserUuid", (Object)socketUserData.getSocketUserUuid());
            }
            this.logger.info("authenticated user");
        }
        catch (AdminInvalidAccessTokenException | UserInvalidAccessTokenException e) {
            throw new EzyLoginErrorException((EzyILoginError)EzyLoginError.INVALID_TOKEN, (Exception)e);
        }
    }

    protected SocketUserData doOnMissingAccessToken(EzyPluginContext context, EzyUserLoginEvent event) {
        EzyUserManagementSetting userManagementSetting = context.getParent().getZone().getSetting().getUserManagement();
        if (userManagementSetting.isAllowGuestLogin()) {
            return SocketUserData.builder().socketUserType((ISocketUserType)SocketUserType.ANONYMOUS).build();
        }
        throw new EzyLoginErrorException((EzyILoginError)EzyLoginError.INVALID_TOKEN);
    }

    protected SocketUserData handleUserLogin(EzyUserLoginEvent event, String userAccessToken) {
        UserModel user = this.userService.getUserByAccessToken(userAccessToken);
        event.setUsername(this.extractUsername(user));
        return SocketUserData.builder().userId(user.getId()).userUuid(user.getUuid()).userAccessToken(userAccessToken).socketUserType((ISocketUserType)SocketUserType.USER).build();
    }

    protected String extractUsername(UserModel user) {
        return SocketUserType.USER + "#" + user.getId();
    }

    protected SocketUserData handleAdminLogin(EzyUserLoginEvent event, String adminAccessToken) {
        if (EzyStrings.isBlank((String)adminAccessToken)) {
            throw new EzyLoginErrorException((EzyILoginError)EzyLoginError.INVALID_TOKEN);
        }
        AdminModel admin = this.adminService.getAdminByAccessToken(adminAccessToken);
        event.setUsername(this.extractAdminUsername(admin));
        return SocketUserData.builder().adminId(admin.getId()).adminUuid(admin.getUuid()).adminAccessToken(adminAccessToken).socketUserType((ISocketUserType)SocketUserType.ADMIN).build();
    }

    protected String extractAdminUsername(AdminModel admin) {
        return SocketUserType.ADMIN + "#" + admin.getId();
    }

    @Generated
    public SocketLoginController(SocketAdminService adminService, SocketUserService userService) {
        this.adminService = adminService;
        this.userService = userService;
    }
}

