/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.service;

import org.youngmonkeys.ezyplatform.converter.DefaultEntityToModelConverter;
import org.youngmonkeys.ezyplatform.entity.User;
import org.youngmonkeys.ezyplatform.model.UserModel;
import org.youngmonkeys.ezyplatform.pagination.ComplexPaginationParameterConverter;
import org.youngmonkeys.ezyplatform.pagination.IdDescUserPaginationParameter;
import org.youngmonkeys.ezyplatform.pagination.UserFilter;
import org.youngmonkeys.ezyplatform.pagination.UserPaginationParameter;
import org.youngmonkeys.ezyplatform.pagination.UserPaginationParameterConverter;
import org.youngmonkeys.ezyplatform.repo.PaginationRepository;
import org.youngmonkeys.ezyplatform.repo.PaginationUserRepository;
import org.youngmonkeys.ezyplatform.service.CommonPaginationService;
import org.youngmonkeys.ezyplatform.service.DataRecordCountService;

public class PaginationUserService
extends CommonPaginationService<UserModel, UserFilter, UserPaginationParameter, Long, User> {
    private final DataRecordCountService dataRecordCountService;
    private final DefaultEntityToModelConverter entityToModelConverter;

    public PaginationUserService(DataRecordCountService dataRecordCountService, PaginationUserRepository repository, DefaultEntityToModelConverter entityToModelConverter, UserPaginationParameterConverter paginationParameterConverter) {
        super((PaginationRepository)repository, (ComplexPaginationParameterConverter)paginationParameterConverter);
        this.dataRecordCountService = dataRecordCountService;
        this.entityToModelConverter = entityToModelConverter;
    }

    protected long getTotalItems(UserFilter filter) {
        return filter.hasNoParameter() ? this.dataRecordCountService.getRecordCount("ezy_users") : super.getTotalItems((Object)filter);
    }

    protected UserModel convertEntity(User user) {
        return this.entityToModelConverter.toModel(user);
    }

    protected UserPaginationParameter defaultPaginationParameter() {
        return new IdDescUserPaginationParameter();
    }
}

