/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.util;

import java.net.URI;
import java.security.SecureRandom;
import java.util.UUID;

public final class Randoms {
    private static final int DISPLAY_NAME_LENGTH = 16;
    private static final String DISPLAY_NAME_CHARACTERS = "abcdefghijklmnopqrstuvwxyz0123456789";
    private static final int DISPLAY_NAME_CHARACTER_LENGTH = "abcdefghijklmnopqrstuvwxyz0123456789".length();

    private Randoms() {
    }

    public static String randomName() {
        return Randoms.randomName(16);
    }

    public static String randomName(int length) {
        SecureRandom random = new SecureRandom();
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            sb.append(DISPLAY_NAME_CHARACTERS.charAt(random.nextInt(DISPLAY_NAME_CHARACTER_LENGTH)));
        }
        return sb.toString();
    }

    public static String randomEmailFromUrl(String url) {
        String host = URI.create(url).getHost();
        return Randoms.randomEmailFromHost(host);
    }

    public static String randomEmailFromHost(String host) {
        String domain = host;
        if (host.indexOf(46) < 0) {
            domain = domain + ".com";
        }
        return UUID.randomUUID() + "@" + domain;
    }
}

