/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.devtools.repository;

import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyfox.stream.EzyAnywayInputStreamLoader;
import com.tvd12.ezyfox.stream.EzyInputStreams;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.Table;

public class RepositoryClassesGenerator {
    private final String basePackageName;
    private final Class<?> customIdClass;
    private final String idClassName;
    private final String entityClassName;
    private final String entityVariableName;
    private final String tableName;
    private final String projectName;
    private final Path baseFolderPath;
    private final String adminIntegrationTestClassTemplate;
    private final String moduleRepositoryInterfaceTemplate;
    private final String sdkRepositoryClassTemplate;

    public RepositoryClassesGenerator(Class<?> entityClass) throws Exception {
        String packageName = entityClass.getPackage().getName();
        this.basePackageName = packageName.substring(0, packageName.indexOf(".entity"));
        this.entityClassName = entityClass.getSimpleName();
        this.entityVariableName = this.entityClassName.substring(0, 1).toLowerCase() + this.entityClassName.substring(1);
        IdClass idClassAnnotation = entityClass.getDeclaredAnnotation(IdClass.class);
        this.customIdClass = idClassAnnotation != null ? idClassAnnotation.value() : null;
        this.idClassName = this.extractIdClassName(entityClass);
        Table tableAnnotation = entityClass.getDeclaredAnnotation(Table.class);
        this.tableName = tableAnnotation != null ? tableAnnotation.name() : "";
        String currentFolderPath = new File("").getAbsolutePath();
        Path baseFolderPathTemp = Paths.get(currentFolderPath, new String[0]);
        if (currentFolderPath.endsWith("sdk")) {
            baseFolderPathTemp = baseFolderPathTemp.getParent();
        }
        this.baseFolderPath = baseFolderPathTemp;
        this.projectName = this.baseFolderPath.getFileName().toString();
        this.adminIntegrationTestClassTemplate = this.readTemplate("admin_integration_test_class.txt");
        this.moduleRepositoryInterfaceTemplate = this.readTemplate("module_repo_class.txt");
        this.sdkRepositoryClassTemplate = this.readTemplate("sdk_repo_class.txt");
    }

    private String extractIdClassName(Class<?> entityClass) {
        String idClassName = null;
        if (this.customIdClass != null) {
            idClassName = this.customIdClass.getSimpleName();
        } else {
            for (Field field : entityClass.getDeclaredFields()) {
                if (!field.isAnnotationPresent(Id.class)) continue;
                Class<?> type = field.getType();
                if (type == Integer.TYPE) {
                    idClassName = "Integer";
                    break;
                }
                if (type == Long.TYPE) {
                    idClassName = "Long";
                    break;
                }
                idClassName = type.getSimpleName();
                break;
            }
        }
        if (idClassName == null) {
            throw new IllegalStateException("entity: " + this.entityClassName + " has no id field");
        }
        return idClassName;
    }

    private String readTemplate(String templateFileName) throws IOException {
        EzyAnywayInputStreamLoader loader = new EzyAnywayInputStreamLoader();
        String filepath = "templates/repository/" + templateFileName;
        try (InputStream inputStream = loader.load(filepath);){
            String string = EzyInputStreams.toStringUtf8((InputStream)inputStream);
            return string;
        }
    }

    public void generate() throws Exception {
        this.generateRepositoryClass("", "sdk", "repo", this.entityClassName + "Repository", this.sdkRepositoryClassTemplate);
        this.generateRepositoryClass("Admin", "admin-plugin", "repo", "Admin" + this.entityClassName + "Repository", this.moduleRepositoryInterfaceTemplate);
        this.generateRepositoryClass("Admin", "admin-plugin", "it.repo", "Admin" + this.entityClassName + "RepositoryIT", this.adminIntegrationTestClassTemplate);
        this.generateRepositoryClass("Web", "web-plugin", "repo", "Web" + this.entityClassName + "Repository", this.moduleRepositoryInterfaceTemplate);
    }

    private void generateRepositoryClass(String moduleType, String moduleNameSuffix, String subPackageName, String className, String template) throws IOException {
        Path filePath;
        String moduleNameFull = this.projectName + "-" + moduleNameSuffix;
        Path folderPath = this.baseFolderPath.resolve(moduleNameFull);
        if (!Files.exists(folderPath, new LinkOption[0])) {
            System.out.println("Module: " + moduleNameFull + " doest not exists");
        }
        String mainFolder = "main";
        if (subPackageName.contains("it") && className.endsWith("IT")) {
            mainFolder = "test";
        }
        Path sourcePath = folderPath.resolve(Paths.get("src", mainFolder, "java"));
        String packageName = this.basePackageName;
        if (EzyStrings.isNotBlank((String)moduleType)) {
            packageName = packageName + "." + moduleType.toLowerCase();
        }
        packageName = packageName + "." + subPackageName;
        String packagePath = packageName.replace(".", "/");
        Path packageFolderPath = folderPath.resolve(sourcePath).resolve(packagePath);
        if (!Files.exists(packageFolderPath, new LinkOption[0])) {
            Files.createDirectories(packageFolderPath, new FileAttribute[0]);
        }
        if (!Files.exists(filePath = packageFolderPath.resolve(className + ".java"), new LinkOption[0])) {
            Files.createFile(filePath, new FileAttribute[0]);
        }
        String moduleName = EzyStrings.toDisplayName((String)this.projectName).replace(" ", "");
        String content = this.generateContent(moduleType, template, moduleName);
        Files.write(filePath, content.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    private String generateContent(String moduleType, String template, String moduleName) {
        String importIdClass = this.customIdClass == null ? "" : "import " + this.customIdClass.getName() + ";\n";
        return template.replace("${basePackageName}", this.basePackageName).replace("${idClassName}", this.idClassName).replace("${entityClassName}", this.entityClassName).replace("${tableName}", this.tableName).replace("${moduleType}", moduleType).replace("${moduleTypeLowercase}", moduleType.toLowerCase()).replace("${moduleName}", moduleName).replace("${entityVariableName}", this.entityVariableName).replace("${importIdClass}", importIdClass);
    }
}

