/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.controller.view;

import com.tvd12.ezyfox.annotation.EzyFeature;
import com.tvd12.ezyhttp.core.exception.HttpNotFoundException;
import com.tvd12.ezyhttp.server.core.annotation.Authenticated;
import com.tvd12.ezyhttp.server.core.annotation.Controller;
import com.tvd12.ezyhttp.server.core.annotation.DoGet;
import com.tvd12.ezyhttp.server.core.annotation.PathVariable;
import com.tvd12.ezyhttp.server.core.annotation.RequestParam;
import com.tvd12.ezyhttp.server.core.view.View;
import java.util.Collections;
import lombok.Generated;
import org.youngmonkeys.ezyplatform.admin.manager.AdminViewMetadataManager;
import org.youngmonkeys.ezyplatform.admin.service.AdminMediaService;
import org.youngmonkeys.ezyplatform.admin.service.AdminUserRoleService;
import org.youngmonkeys.ezyplatform.admin.service.AdminUserService;
import org.youngmonkeys.ezyplatform.admin.validator.AdminUsersValidator;
import org.youngmonkeys.ezyplatform.admin.view.AdminViewFactory;
import org.youngmonkeys.ezyplatform.admin.view.AdminViewName;
import org.youngmonkeys.ezyplatform.annotation.AdminRoles;
import org.youngmonkeys.ezyplatform.data.AdminRolesProxy;
import org.youngmonkeys.ezyplatform.data.ViewMetadata;
import org.youngmonkeys.ezyplatform.model.UserModel;
import org.youngmonkeys.ezyplatform.model.UserRoleNameModel;
import org.youngmonkeys.ezyplatform.rx.Reactive;

@Authenticated
@Controller
@EzyFeature(value="user_management")
public class AdminUsersController {
    private final AdminViewFactory viewFactory;
    private final AdminViewMetadataManager viewMetadataManager;
    private final AdminUserService userService;
    private final AdminUserRoleService userRoleService;
    private final AdminMediaService mediaService;
    private final AdminUsersValidator usersValidator;

    @DoGet(value="/users/add")
    public View usersAddGet(@RequestParam(value="previousScreen") String previousScreen, @RequestParam(value="queryString") String queryString) {
        View.Builder viewBuilder = this.viewFactory.newUsersViewBuilder(AdminViewName.ADD).addVariable("roles", this.userRoleService.getUserRoles());
        this.decorateViewBuilder(previousScreen, queryString, viewBuilder);
        return viewBuilder.build();
    }

    @DoGet(value="/users")
    public View usersGet(@AdminRoles AdminRolesProxy adminRoles, @RequestParam(value="keyword") String keyword, @RequestParam(value="userStatus") String userStatus) {
        return this.viewFactory.newUsersViewBuilder(AdminViewName.LIST).addVariable("enableAddNewButton", (Object)adminRoles.isAccessible("/users/add")).addVariable("userStatuses", (Object)this.userService.getAllUserStatuses()).addVariable("userSearchKeyword", (Object)keyword).addVariable("userSearchStatus", (Object)userStatus).build();
    }

    @DoGet(value="/users/{username}")
    public View usersUsernameGet(@PathVariable String username, @AdminRoles AdminRolesProxy adminRoles, @RequestParam(value="previousScreen") String previousScreen, @RequestParam(value="queryString") String queryString) {
        UserModel user = this.usersValidator.validate(username);
        View.Builder viewBuilder = (View.Builder)Reactive.multiple().register((Object)"userAvatarImage", () -> this.mediaService.getMediaNameById(user.getAvatarImageId())).register((Object)"userCoverImage", () -> this.mediaService.getMediaNameById(user.getCoverImageId())).register((Object)"userRoles", () -> this.userRoleService.getUserRolesByUserId(user.getId())).blockingGet(it -> this.viewFactory.newUsersViewBuilder(AdminViewName.PROFILE).addVariable("selectedUser", (Object)user).addVariables(it.valueMap()).addVariable("enableEditButton", (Object)adminRoles.isAccessible("/users/{username}/edit")));
        this.decorateViewBuilder(previousScreen, queryString, viewBuilder);
        return viewBuilder.build();
    }

    @DoGet(value="/users/{username}/edit")
    public View usersEditGet(@PathVariable String username, @RequestParam(value="previousScreen") String previousScreen, @RequestParam(value="queryString") String queryString) {
        UserModel user = this.userService.getUserByUsername(username);
        View.Builder viewBuilder = (View.Builder)Reactive.multiple().register((Object)"userAvatarImage", () -> this.mediaService.getMediaNameById(user.getAvatarImageId())).register((Object)"userCoverImage", () -> this.mediaService.getMediaNameById(user.getCoverImageId())).register((Object)"roles", this.userRoleService::getUserRoles).register((Object)"editUserRoles", () -> this.userRoleService.getUserRolesByUserId(user.getId())).blockingGet(it -> this.viewFactory.newUsersViewBuilder(AdminViewName.EDIT).addVariables(it.valueMap()).addVariable("editUser", (Object)user));
        this.decorateViewBuilder(previousScreen, queryString, viewBuilder);
        return viewBuilder.build();
    }

    @DoGet(value="/users/roles")
    public View usersRolesGet() {
        return this.viewFactory.newUsersViewBuilder(AdminViewName.ROLES).addVariable("enableAddNewButton", (Object)true).build();
    }

    @DoGet(value="/users/roles/{roleName}")
    public View userRolesRoleNameGet(@PathVariable String roleName) {
        UserRoleNameModel role = this.userRoleService.getUserRoleNameByName(roleName);
        if (role == null) {
            throw new HttpNotFoundException(Collections.singletonMap("role", "notFound"));
        }
        return this.viewFactory.newUsersViewBuilder(AdminViewName.ROLE_DETAILS).addVariable("role", (Object)role).addVariable("enableEditButton", (Object)true).build();
    }

    private void decorateViewBuilder(String previousScreen, String queryString, View.Builder viewBuilder) {
        String currentParentURL;
        String currentParentTitle;
        if (previousScreen == null) {
            return;
        }
        ViewMetadata viewMetadata = this.viewMetadataManager.getViewMetadataByName(previousScreen);
        if (viewMetadata == null) {
            return;
        }
        viewBuilder.addVariable("previousScreen", (Object)previousScreen);
        String currentMenu = viewMetadata.getCurrentMenu();
        if (currentMenu != null) {
            viewBuilder.addVariable("currentMenu", (Object)currentMenu);
        }
        if ((currentParentTitle = viewMetadata.getCurrentParentTitle()) != null) {
            viewBuilder.addVariable("currentParentTitle", (Object)currentParentTitle);
        }
        if ((currentParentURL = viewMetadata.getCurrentParentURL()) != null) {
            if (queryString != null) {
                currentParentURL = currentParentURL + queryString;
                viewBuilder.addVariable("previousQueryString", (Object)queryString);
            }
            viewBuilder.addVariable("currentParentURL", (Object)currentParentURL);
        }
    }

    @Generated
    public AdminUsersController(AdminViewFactory viewFactory, AdminViewMetadataManager viewMetadataManager, AdminUserService userService, AdminUserRoleService userRoleService, AdminMediaService mediaService, AdminUsersValidator usersValidator) {
        this.viewFactory = viewFactory;
        this.viewMetadataManager = viewMetadataManager;
        this.userService = userService;
        this.userRoleService = userRoleService;
        this.mediaService = mediaService;
        this.usersValidator = usersValidator;
    }
}

