/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.devtools;

import com.tvd12.ezyfox.reflect.EzyClass;
import com.tvd12.ezyfox.reflect.EzyClasses;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.youngmonkeys.devtools.InstanceRandom;

public class UnitTestClassGenerator {
    private final String classSimpleName;
    private final Constructor<?> constructor;
    private final List<String> imports = new ArrayList<String>();
    private final List<String> content = new ArrayList<String>();

    public UnitTestClassGenerator(Class<?> javaClass) {
        EzyClass clazz = new EzyClass(javaClass);
        this.classSimpleName = javaClass.getSimpleName();
        this.constructor = clazz.getDeclaredConstructors().stream().max(Comparator.comparingInt(Constructor::getParameterCount)).orElse(null);
    }

    public void printContent() {
        System.out.println(this.generateContent());
    }

    public String generateContent() {
        ArrayList<String> params;
        Class[] componentClasses;
        this.imports.addAll(Arrays.asList("org.testng.annotations.*;", "static org.mockito.Mockito.*;"));
        this.imports.add(InstanceRandom.class.getName() + ";");
        for (Class componentClass : componentClasses = this.constructor == null ? new Class[]{} : this.constructor.getParameterTypes()) {
            this.imports.add(componentClass.getName() + ";");
        }
        this.content.add(this.imports.stream().distinct().map(it -> "import " + it).collect(Collectors.joining("\n")));
        this.content.add("");
        this.content.add("public class " + this.classSimpleName + "Test {");
        for (Class componentClass : componentClasses) {
            this.content.add(UnitTestClassGenerator.tabs(1) + "private " + componentClass.getSimpleName() + " " + EzyClasses.getVariableName((Class)componentClass) + ";");
        }
        this.content.add(UnitTestClassGenerator.tabs(1) + "private " + this.classSimpleName + " instance;");
        this.content.add("");
        this.content.add(UnitTestClassGenerator.tabs(1) + "private final InstanceRandom instanceRandom =");
        this.content.add(UnitTestClassGenerator.tabs(2) + "new InstanceRandom();");
        this.content.add("");
        this.content.add(UnitTestClassGenerator.tabs(1) + "@BeforeMethod");
        this.content.add(UnitTestClassGenerator.tabs(1) + "public void setup() {");
        for (Class componentClass : componentClasses) {
            this.content.add(UnitTestClassGenerator.tabs(2) + EzyClasses.getVariableName((Class)componentClass) + " = mock(" + componentClass.getSimpleName() + ".class);");
        }
        if (componentClasses.length == 0) {
            this.content.add(UnitTestClassGenerator.tabs(2) + "instance = new " + this.classSimpleName + "();");
        } else {
            this.content.add(UnitTestClassGenerator.tabs(2) + "instance = new " + this.classSimpleName + "(");
            params = new ArrayList<String>();
            for (Class componentClass : componentClasses) {
                params.add(UnitTestClassGenerator.tabs(3) + EzyClasses.getVariableName((Class)componentClass));
            }
            this.content.add(String.join((CharSequence)",\n", params));
            this.content.add(UnitTestClassGenerator.tabs(2) + ");");
        }
        this.content.add(UnitTestClassGenerator.tabs(1) + "}");
        if (componentClasses.length > 0) {
            this.content.add("");
            this.content.add(UnitTestClassGenerator.tabs(1) + "@AfterMethod");
            this.content.add(UnitTestClassGenerator.tabs(1) + "public void verifyAll() {");
            this.content.add(UnitTestClassGenerator.tabs(2) + "verifyNoMoreInteractions(");
            params = new ArrayList();
            for (Class componentClass : componentClasses) {
                params.add(UnitTestClassGenerator.tabs(3) + EzyClasses.getVariableName((Class)componentClass));
            }
            this.content.add(String.join((CharSequence)",\n", params));
            this.content.add(UnitTestClassGenerator.tabs(2) + ");");
            this.content.add(UnitTestClassGenerator.tabs(1) + "}");
        }
        this.content.add("}");
        return String.join((CharSequence)"\n", this.content);
    }

    private static String tabs(int count) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            builder.append("    ");
        }
        return builder.toString();
    }
}

