/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.devtools.filewatch;

import com.tvd12.ezyfox.util.EzyLoggable;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.youngmonkeys.devtools.filewatch.FileListener;

public class FileWatcher
extends EzyLoggable
implements Runnable {
    protected volatile boolean active;
    protected final Path folder;
    protected final Map<Path, Long> fileStates;
    protected final FileListener fileListener;
    protected static final long SLEEP_TIME = 250L;

    public FileWatcher(Path folder, FileListener fileListener) {
        this.folder = folder;
        this.fileStates = new HashMap<Path, Long>();
        this.fileStates.putAll(this.walkFiles());
        this.fileListener = fileListener;
    }

    public void watch() {
        Thread thread = new Thread(this);
        thread.setDaemon(true);
        thread.setName("devtools-file-watcher");
        thread.start();
    }

    @Override
    public void run() {
        this.active = true;
        while (this.active) {
            try {
                Thread.sleep(250L);
                ArrayList<Path> modifiedFiles = new ArrayList<Path>();
                Map<Path, Long> newStates = this.walkFiles();
                for (Path file : newStates.keySet()) {
                    Long oldState;
                    Long newState = newStates.get(file);
                    if (newState.equals(oldState = this.fileStates.get(file))) continue;
                    modifiedFiles.add(file);
                }
                this.fileStates.clear();
                this.fileStates.putAll(newStates);
                modifiedFiles.forEach(this.fileListener::onFileModified);
            }
            catch (Exception e) {
                this.logger.warn("watch folder: {} error", (Object)this.folder, (Object)e);
            }
        }
    }

    public void stop() {
        this.active = false;
    }

    private Map<Path, Long> walkFiles() {
        try {
            return Files.walk(this.folder, Integer.MAX_VALUE, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(it -> !it.getFileName().toString().endsWith("~")).collect(Collectors.toMap(it -> it, it -> it.toFile().lastModified()));
        }
        catch (Exception e) {
            if (e instanceof NoSuchFileException) {
                this.logger.info("walk folder: {} stopped due to: {}", (Object)this.folder, (Object)e.getMessage());
            } else {
                this.logger.warn("walk folder: {} error", (Object)this.folder, (Object)e);
            }
            return Collections.emptyMap();
        }
    }
}

