/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.devtools.pagination;

import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyfox.stream.EzyAnywayInputStreamLoader;
import com.tvd12.ezyfox.stream.EzyInputStreams;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import javax.persistence.Table;

public class PaginationClassesGenerator {
    private final String basePackageName;
    private final String entityClassName;
    private final String entityVariableName;
    private final String tableName;
    private final String projectName;
    private final Path baseFolderPath;
    private final String adminIntegrationTestClassTemplate;
    private final String defaultFilterClassTemplate;
    private final String filterInterfaceTemplate;
    private final String idAscPaginationParameterClass;
    private final String idDescPaginationParameterClass;
    private final String modulePaginationParameterConverterClassTemplate;
    private final String modulePaginationRepoClassTemplate;
    private final String modulePaginationServiceClassTemplate;
    private final String paginationParameterInterfaceTemplate;
    private final String paginationParameterConverterClassTemplate;
    private final String paginationSortOrderClassTemplate;
    private final String sdkPaginationRepoClassTemplate;
    private final String sdkPaginationServiceClassTemplate;

    public PaginationClassesGenerator(Class<?> entityClass) throws Exception {
        String packageName = entityClass.getPackage().getName();
        this.basePackageName = packageName.substring(0, packageName.indexOf(".entity"));
        this.entityClassName = entityClass.getSimpleName();
        this.entityVariableName = this.entityClassName.substring(0, 1).toLowerCase() + this.entityClassName.substring(1);
        Table tableAnnotation = entityClass.getDeclaredAnnotation(Table.class);
        this.tableName = tableAnnotation != null ? tableAnnotation.name() : "";
        String currentFolderPath = new File("").getAbsolutePath();
        Path baseFolderPathTemp = Paths.get(currentFolderPath, new String[0]);
        if (currentFolderPath.endsWith("sdk")) {
            baseFolderPathTemp = baseFolderPathTemp.getParent();
        }
        this.baseFolderPath = baseFolderPathTemp;
        this.projectName = this.baseFolderPath.getFileName().toString();
        this.adminIntegrationTestClassTemplate = this.readTemplate("admin_integration_test_class.txt");
        this.defaultFilterClassTemplate = this.readTemplate("default_filter_class.txt");
        this.filterInterfaceTemplate = this.readTemplate("filter_interface.txt");
        this.idAscPaginationParameterClass = this.readTemplate("id_asc_pagination_parameter_class.txt");
        this.idDescPaginationParameterClass = this.readTemplate("id_desc_pagination_parameter_class.txt");
        this.modulePaginationParameterConverterClassTemplate = this.readTemplate("module_pagination_parameter_converter_class.txt");
        this.modulePaginationRepoClassTemplate = this.readTemplate("module_pagination_repo_class.txt");
        this.modulePaginationServiceClassTemplate = this.readTemplate("module_pagination_service_class.txt");
        this.paginationParameterInterfaceTemplate = this.readTemplate("pagination_parameter_interface.txt");
        this.paginationParameterConverterClassTemplate = this.readTemplate("pagination_paramter_converter_class.txt");
        this.paginationSortOrderClassTemplate = this.readTemplate("pagination_sort_order_class.txt");
        this.sdkPaginationRepoClassTemplate = this.readTemplate("sdk_pagination_repo_class.txt");
        this.sdkPaginationServiceClassTemplate = this.readTemplate("sdk_pagination_service_class.txt");
    }

    private String readTemplate(String templateFileName) throws IOException {
        EzyAnywayInputStreamLoader loader = new EzyAnywayInputStreamLoader();
        String filepath = "templates/pagination/" + templateFileName;
        try (InputStream inputStream = loader.load(filepath);){
            String string = EzyInputStreams.toStringUtf8((InputStream)inputStream);
            return string;
        }
    }

    public void generate() throws Exception {
        this.generatePaginationClass("", "sdk", "pagination", this.entityClassName + "Filter", this.filterInterfaceTemplate);
        this.generatePaginationClass("", "sdk", "pagination", "Default" + this.entityClassName + "Filter", this.defaultFilterClassTemplate);
        this.generatePaginationClass("", "sdk", "pagination", this.entityClassName + "PaginationParameter", this.paginationParameterInterfaceTemplate);
        this.generatePaginationClass("", "sdk", "pagination", this.entityClassName + "PaginationParameterConverter", this.paginationParameterConverterClassTemplate);
        this.generatePaginationClass("", "sdk", "pagination", this.entityClassName + "PaginationSortOrder", this.paginationSortOrderClassTemplate);
        this.generatePaginationClass("", "sdk", "pagination", "IdAsc" + this.entityClassName + "PaginationParameter", this.idAscPaginationParameterClass);
        this.generatePaginationClass("", "sdk", "pagination", "IdDesc" + this.entityClassName + "PaginationParameter", this.idDescPaginationParameterClass);
        this.generatePaginationClass("", "sdk", "repo", "Pagination" + this.entityClassName + "Repository", this.sdkPaginationRepoClassTemplate);
        this.generatePaginationClass("", "sdk", "service", "Pagination" + this.entityClassName + "Service", this.sdkPaginationServiceClassTemplate);
        this.generatePaginationClass("Admin", "admin-plugin", "pagination", "Admin" + this.entityClassName + "PaginationParameterConverter", this.modulePaginationParameterConverterClassTemplate);
        this.generatePaginationClass("Admin", "admin-plugin", "repo", "AdminPagination" + this.entityClassName + "Repository", this.modulePaginationRepoClassTemplate);
        this.generatePaginationClass("Admin", "admin-plugin", "service", "AdminPagination" + this.entityClassName + "Service", this.modulePaginationServiceClassTemplate);
        this.generatePaginationClass("Admin", "admin-plugin", "it.service", "AdminPagination" + this.entityClassName + "ServiceIT", this.adminIntegrationTestClassTemplate);
        this.generatePaginationClass("Web", "web-plugin", "pagination", "Web" + this.entityClassName + "PaginationParameterConverter", this.modulePaginationParameterConverterClassTemplate);
        this.generatePaginationClass("Web", "web-plugin", "repo", "WebPagination" + this.entityClassName + "Repository", this.modulePaginationRepoClassTemplate);
        this.generatePaginationClass("Web", "web-plugin", "service", "WebPagination" + this.entityClassName + "Service", this.modulePaginationServiceClassTemplate);
    }

    private void generatePaginationClass(String moduleType, String moduleNameSuffix, String subPackageName, String className, String template) throws IOException {
        Path filePath;
        String moduleNameFull = this.projectName + "-" + moduleNameSuffix;
        Path folderPath = this.baseFolderPath.resolve(moduleNameFull);
        if (!Files.exists(folderPath, new LinkOption[0])) {
            System.out.println("Module: " + moduleNameFull + " doest not exists");
        }
        String mainFolder = "main";
        if (subPackageName.contains("it") && className.endsWith("IT")) {
            mainFolder = "test";
        }
        Path sourcePath = folderPath.resolve(Paths.get("src", mainFolder, "java"));
        String packageName = this.basePackageName;
        if (EzyStrings.isNotBlank((String)moduleType)) {
            packageName = packageName + "." + moduleType.toLowerCase();
        }
        packageName = packageName + "." + subPackageName;
        String packagePath = packageName.replace(".", "/");
        Path packageFolderPath = folderPath.resolve(sourcePath).resolve(packagePath);
        if (!Files.exists(packageFolderPath, new LinkOption[0])) {
            Files.createDirectories(packageFolderPath, new FileAttribute[0]);
        }
        if (!Files.exists(filePath = packageFolderPath.resolve(className + ".java"), new LinkOption[0])) {
            Files.createFile(filePath, new FileAttribute[0]);
        }
        String moduleName = EzyStrings.toDisplayName((String)this.projectName).replace(" ", "");
        String content = template.replace("${basePackageName}", this.basePackageName).replace("${entityClassName}", this.entityClassName).replace("${entityVariableName}", this.entityVariableName).replace("${tableName}", this.tableName).replace("${moduleType}", moduleType).replace("${moduleTypeLowercase}", moduleType.toLowerCase()).replace("${moduleName}", moduleName);
        Files.write(filePath, content.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }
}

