/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.cli.io;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.youngmonkeys.ezyplatform.cli.data.ModuleMetadata;
import org.youngmonkeys.ezyplatform.cli.io.CliFolderProxy;
import org.youngmonkeys.ezyplatform.cli.io.CliObjectMapper;

public final class CliModuleMetadataMapReader {
    public static final CliModuleMetadataMapReader INSTANCE = new CliModuleMetadataMapReader();

    private CliModuleMetadataMapReader() {
    }

    public static CliModuleMetadataMapReader getInstance() {
        return INSTANCE;
    }

    public Map<String, ModuleMetadata> readByTargetAndFileName(String target, String metadataFileName) throws Exception {
        File metadataFile = CliFolderProxy.getModuleMetadataFileByTarget(target, metadataFileName);
        return this.readByFile(metadataFile);
    }

    public Map<String, Map<String, ModuleMetadata>> readByModuleTypes(List<String> moduleTypes) throws Exception {
        HashMap<String, Map<String, ModuleMetadata>> answer = new HashMap<String, Map<String, ModuleMetadata>>();
        for (String moduleType : moduleTypes) {
            File metadataFile = CliFolderProxy.getModuleMetadataFileByModuleType(moduleType);
            answer.put(moduleType, this.readByFile(metadataFile));
        }
        return answer;
    }

    public Map<String, ModuleMetadata> readByFile(File metaDataFile) throws Exception {
        ModuleMetadata[] moduleMetadataArray = metaDataFile.exists() ? CliObjectMapper.getInstance().readValue(metaDataFile, ModuleMetadata[].class) : new ModuleMetadata[]{};
        return Arrays.stream(moduleMetadataArray).collect(Collectors.toMap(ModuleMetadata::getName, it -> it));
    }
}

