/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.codec;

import com.tvd12.ezyfox.codec.EzyMessageDeserializer;
import com.tvd12.ezyfox.codec.MsgPackType;
import com.tvd12.ezyfox.codec.MsgPackTypeParser;
import com.tvd12.ezyfox.entity.EzyArray;
import com.tvd12.ezyfox.entity.EzyObject;
import com.tvd12.ezyfox.exception.EzyCodecException;
import com.tvd12.ezyfox.factory.EzyEntityFactory;
import com.tvd12.ezyfox.function.EzyParser;
import com.tvd12.ezyfox.io.EzyBytes;
import com.tvd12.ezyfox.io.EzyInts;
import com.tvd12.ezyfox.io.EzyLongs;
import com.tvd12.ezyfox.io.EzyStrings;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MsgPackSimpleDeserializer
implements EzyMessageDeserializer {
    protected final MsgPackTypeParser typeParser = new MsgPackTypeParser();
    protected final MapSizeDeserializer mapSizeDeserializer = new MapSizeDeserializer();
    protected final ArraySizeDeserializer arraySizeDeserializer = new ArraySizeDeserializer();
    protected final StringSizeDeserializer stringSizeDeserializer = new StringSizeDeserializer();
    protected final Map<MsgPackType, EzyParser<ByteBuffer, Object>> parsers = this.defaultParsers();

    public Object deserialize(ByteBuffer buffer) {
        return this.deserialize(buffer, buffer.get() & 0xFF);
    }

    protected Object deserialize(ByteBuffer buffer, int type) {
        buffer.position(buffer.position() - 1);
        return this.deserialize(buffer, this.getDataType(type));
    }

    protected Object deserialize(ByteBuffer buffer, MsgPackType type) {
        EzyParser<ByteBuffer, Object> parser = this.parsers.get((Object)type);
        return parser.parse((Object)buffer);
    }

    protected Map<MsgPackType, EzyParser<ByteBuffer, Object>> defaultParsers() {
        ConcurrentHashMap<MsgPackType, EzyParser<ByteBuffer, Object>> parsers = new ConcurrentHashMap<MsgPackType, EzyParser<ByteBuffer, Object>>();
        this.addParsers(parsers);
        return parsers;
    }

    protected void addParsers(Map<MsgPackType, EzyParser<ByteBuffer, Object>> parsers) {
        parsers.put(MsgPackType.POSITIVE_FIXINT, (EzyParser<ByteBuffer, Object>)((EzyParser)this::parsePositiveFixInt));
        parsers.put(MsgPackType.NEGATIVE_FIXINT, (EzyParser<ByteBuffer, Object>)((EzyParser)this::parseNegativeFixInt));
        parsers.put(MsgPackType.UINT8, (EzyParser<ByteBuffer, Object>)((EzyParser)this::parseUInt8));
        parsers.put(MsgPackType.UINT16, (EzyParser<ByteBuffer, Object>)((EzyParser)this::parseUInt16));
        parsers.put(MsgPackType.UINT32, (EzyParser<ByteBuffer, Object>)((EzyParser)this::parseUInt32));
        parsers.put(MsgPackType.UINT64, (EzyParser<ByteBuffer, Object>)((EzyParser)this::parseUInt64));
        parsers.put(MsgPackType.INT8, (EzyParser<ByteBuffer, Object>)((EzyParser)this::parseInt8));
        parsers.put(MsgPackType.INT16, (EzyParser<ByteBuffer, Object>)((EzyParser)this::parseInt16));
        parsers.put(MsgPackType.INT32, (EzyParser<ByteBuffer, Object>)((EzyParser)this::parseInt32));
        parsers.put(MsgPackType.INT64, (EzyParser<ByteBuffer, Object>)((EzyParser)this::parseInt64));
        parsers.put(MsgPackType.FIXMAP, (EzyParser<ByteBuffer, Object>)((EzyParser)this::parseFixMap));
        parsers.put(MsgPackType.MAP16, (EzyParser<ByteBuffer, Object>)((EzyParser)this::parseMap16));
        parsers.put(MsgPackType.MAP32, (EzyParser<ByteBuffer, Object>)((EzyParser)this::parseMap32));
        parsers.put(MsgPackType.FIXARRAY, (EzyParser<ByteBuffer, Object>)((EzyParser)this::parseFixArray));
        parsers.put(MsgPackType.ARRAY16, (EzyParser<ByteBuffer, Object>)((EzyParser)this::parseArray16));
        parsers.put(MsgPackType.ARRAY32, (EzyParser<ByteBuffer, Object>)((EzyParser)this::parseArray32));
        parsers.put(MsgPackType.FIXSTR, (EzyParser<ByteBuffer, Object>)((EzyParser)this::parseFixStr));
        parsers.put(MsgPackType.STR8, (EzyParser<ByteBuffer, Object>)((EzyParser)this::parseStr8));
        parsers.put(MsgPackType.STR16, (EzyParser<ByteBuffer, Object>)((EzyParser)this::parseStr16));
        parsers.put(MsgPackType.STR32, (EzyParser<ByteBuffer, Object>)((EzyParser)this::parseStr32));
        parsers.put(MsgPackType.NIL, (EzyParser<ByteBuffer, Object>)((EzyParser)this::parseNil));
        parsers.put(MsgPackType.FALSE, (EzyParser<ByteBuffer, Object>)((EzyParser)this::parseFalse));
        parsers.put(MsgPackType.TRUE, (EzyParser<ByteBuffer, Object>)((EzyParser)this::parseTrue));
        parsers.put(MsgPackType.BIN8, (EzyParser<ByteBuffer, Object>)((EzyParser)this::parseBin8));
        parsers.put(MsgPackType.BIN16, (EzyParser<ByteBuffer, Object>)((EzyParser)this::parseBin16));
        parsers.put(MsgPackType.BIN32, (EzyParser<ByteBuffer, Object>)((EzyParser)this::parseBin32));
        parsers.put(MsgPackType.FLOAT32, (EzyParser<ByteBuffer, Object>)((EzyParser)this::parseFloat32));
        parsers.put(MsgPackType.FLOAT64, (EzyParser<ByteBuffer, Object>)((EzyParser)this::parseFloat64));
    }

    protected Object parseFloat32(ByteBuffer buffer) {
        buffer.get();
        return Float.valueOf(buffer.getFloat());
    }

    protected Object parseFloat64(ByteBuffer buffer) {
        buffer.get();
        return buffer.getDouble();
    }

    protected Object parseBin32(ByteBuffer buffer) {
        return this.parseBin(buffer, this.getBinLength(buffer, 4));
    }

    protected Object parseBin16(ByteBuffer buffer) {
        return this.parseBin(buffer, this.getBinLength(buffer, 2));
    }

    protected Object parseBin8(ByteBuffer buffer) {
        return this.parseBin(buffer, this.getBinLength(buffer, 1));
    }

    protected int getBinLength(ByteBuffer buffer, int size) {
        buffer.get();
        return EzyInts.bin2uint((ByteBuffer)buffer, (int)size);
    }

    protected Object parseBin(ByteBuffer buffer, int length) {
        return EzyBytes.copy((ByteBuffer)buffer, (int)length);
    }

    protected Object parseTrue(ByteBuffer buffer) {
        return this.parseValue(buffer, Boolean.TRUE);
    }

    protected Object parseFalse(ByteBuffer buffer) {
        return this.parseValue(buffer, Boolean.FALSE);
    }

    protected Object parseNil(ByteBuffer buffer) {
        return this.parseValue(buffer, null);
    }

    protected Object parseValue(ByteBuffer buffer, Object value) {
        buffer.get();
        return value;
    }

    protected EzyObject parseFixMap(ByteBuffer buffer) {
        return this.parseMap(buffer, this.getMapSize(buffer, 1));
    }

    protected EzyObject parseMap16(ByteBuffer buffer) {
        return this.parseMap(buffer, this.getMapSize(buffer, 3));
    }

    protected EzyObject parseMap32(ByteBuffer buffer) {
        return this.parseMap(buffer, this.getMapSize(buffer, 5));
    }

    protected int getMapSize(ByteBuffer buffer, int nbytes) {
        return this.mapSizeDeserializer.deserialize(buffer, nbytes);
    }

    protected EzyObject parseMap(ByteBuffer buffer, int size) {
        EzyObject object = EzyEntityFactory.newObject();
        for (int i = 0; i < size; ++i) {
            object.put(this.deserialize(buffer), this.deserialize(buffer));
        }
        return object;
    }

    protected String parseStr32(ByteBuffer buffer) {
        return this.parseString(buffer, 5);
    }

    protected String parseStr16(ByteBuffer buffer) {
        return this.parseString(buffer, 3);
    }

    protected String parseStr8(ByteBuffer buffer) {
        return this.parseString(buffer, 2);
    }

    protected String parseFixStr(ByteBuffer buffer) {
        return this.parseString(buffer, 1);
    }

    protected String parseString(ByteBuffer buffer, int nbytes) {
        return EzyStrings.newUtf((ByteBuffer)buffer, (int)this.parseStringSize(buffer, nbytes));
    }

    protected int parseStringSize(ByteBuffer buffer, int nbytes) {
        return this.stringSizeDeserializer.deserialize(buffer, nbytes);
    }

    protected int parsePositiveFixInt(ByteBuffer buffer) {
        return buffer.get() & 0x7F;
    }

    protected int parseNegativeFixInt(ByteBuffer buffer) {
        return buffer.get();
    }

    protected int parseUInt8(ByteBuffer buffer) {
        return this.parseUInt(buffer, 1);
    }

    protected int parseUInt16(ByteBuffer buffer) {
        return this.parseUInt(buffer, 2);
    }

    protected int parseUInt32(ByteBuffer buffer) {
        return this.parseUInt(buffer, 4);
    }

    protected long parseUInt64(ByteBuffer buffer) {
        return this.parseULong(buffer, 8);
    }

    protected int parseInt8(ByteBuffer buffer) {
        return this.parseInt(buffer, 1);
    }

    protected int parseInt16(ByteBuffer buffer) {
        return this.parseInt(buffer, 2);
    }

    protected int parseInt32(ByteBuffer buffer) {
        return this.parseInt(buffer, 4);
    }

    protected long parseInt64(ByteBuffer buffer) {
        return this.parseLong(buffer, 8);
    }

    protected int parseUInt(ByteBuffer buffer, int size) {
        return (int)this.parseULong(buffer, size);
    }

    protected long parseULong(ByteBuffer buffer, int size) {
        buffer.get();
        return EzyLongs.bin2ulong((ByteBuffer)buffer, (int)size);
    }

    protected int parseInt(ByteBuffer buffer, int size) {
        return (int)this.parseLong(buffer, size);
    }

    protected long parseLong(ByteBuffer buffer, int size) {
        buffer.get();
        return EzyLongs.bin2long((ByteBuffer)buffer, (int)size);
    }

    protected EzyArray parseFixArray(ByteBuffer buffer) {
        return this.parseArray(buffer, this.parseArraySize(buffer, 1));
    }

    protected EzyArray parseArray16(ByteBuffer buffer) {
        return this.parseArray(buffer, this.parseArraySize(buffer, 3));
    }

    protected EzyArray parseArray32(ByteBuffer buffer) {
        return this.parseArray(buffer, this.parseArraySize(buffer, 5));
    }

    protected int parseArraySize(ByteBuffer buffer, int nbytes) {
        return this.arraySizeDeserializer.deserialize(buffer, nbytes);
    }

    protected EzyArray parseArray(ByteBuffer buffer, int size) {
        EzyArray array = EzyEntityFactory.newArray();
        for (int i = 0; i < size; ++i) {
            array.add(this.deserialize(buffer));
        }
        return array;
    }

    protected MsgPackType getDataType(int type) {
        MsgPackType answer = this.typeParser.parse(type);
        if (answer != null) {
            return answer;
        }
        throw new EzyCodecException("has no type with type = " + String.format("0x%x", type));
    }

    public static class ArraySizeDeserializer
    extends AbstractSizeDeserializer {
        @Override
        protected int getFix(ByteBuffer buffer) {
            return buffer.get() & 0xF;
        }
    }

    public static class MapSizeDeserializer
    extends AbstractSizeDeserializer {
        @Override
        protected int getFix(ByteBuffer buffer) {
            return buffer.get() & 0xF;
        }
    }

    public static class StringSizeDeserializer
    extends AbstractSizeDeserializer {
        @Override
        protected int getFix(ByteBuffer buffer) {
            return buffer.get() & 0x1F;
        }
    }

    public static abstract class AbstractSizeDeserializer {
        public int deserialize(ByteBuffer buffer, int nbytes) {
            return nbytes == 1 ? this.getFix(buffer) : this.getOther(buffer, nbytes);
        }

        protected abstract int getFix(ByteBuffer var1);

        protected int getOther(ByteBuffer buffer, int nbytes) {
            buffer.get();
            return EzyInts.bin2uint((ByteBuffer)buffer, (int)(nbytes - 1));
        }
    }
}

