/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.reflections.util;

import com.tvd12.reflections.util.AbstractIterator;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class Sets {
    private Sets() {
    }

    public static <T> Set<T> newHashSet(T ... ts) {
        HashSet<T> set = new HashSet<T>();
        for (T t : ts) {
            set.add(t);
        }
        return set;
    }

    public static <T> Set<T> newHashSet(Iterable<T> iterable) {
        HashSet<T> set = new HashSet<T>();
        for (T t : iterable) {
            set.add(t);
        }
        return set;
    }

    public static <T> Set<T> newLinkedHashSet(T ... ts) {
        LinkedHashSet<T> set = new LinkedHashSet<T>();
        for (T t : ts) {
            set.add(t);
        }
        return set;
    }

    public static Set<String> newSetFromMap(ConcurrentHashMap<String, Boolean> map) {
        return Collections.newSetFromMap(map);
    }

    public static <E> SetView<E> difference(final Set<E> a, final Set<E> b) {
        return new SetView<E>(){

            @Override
            public Iterator<E> iterator() {
                return new AbstractIterator<E>(){
                    Iterator<E> itr;
                    {
                        this.itr = a.iterator();
                    }

                    @Override
                    protected E computeNext() {
                        while (this.itr.hasNext()) {
                            Object e = this.itr.next();
                            if (b.contains(e)) continue;
                            return e;
                        }
                        return this.endOfData();
                    }
                };
            }
        };
    }

    public static interface SetView<T>
    extends Iterable<T> {
        @Override
        public Iterator<T> iterator();
    }
}

