/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.codec;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.tvd12.ezyfox.codec.EzyAbstractByTypeSerializer;
import com.tvd12.ezyfox.entity.EzyArray;
import com.tvd12.ezyfox.entity.EzyObject;
import com.tvd12.ezyfox.exception.EzyCodecException;
import com.tvd12.ezyfox.function.EzyParser;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class JacksonSimpleSerializer
extends EzyAbstractByTypeSerializer {
    protected final ObjectMapper objectMapper;

    public JacksonSimpleSerializer(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    protected <T> T parseNil(Class<T> outType) {
        return (T)this.writeValueAsBytes(null);
    }

    protected <T> T parseWithNoParsers(Object value, Class<T> outType) {
        return (T)this.writeValueAsBytes(value);
    }

    protected <T> T parseWithNoParser(Object value, Class<T> outType) {
        return (T)this.writeValueAsBytes(value);
    }

    protected byte[] writeValueAsBytes(Object obj) {
        try {
            return this.objectMapper.writeValueAsBytes(obj);
        }
        catch (JsonProcessingException e) {
            throw new EzyCodecException("write value as bytes error", (Throwable)e);
        }
    }

    protected String writeValueAsString(Object obj) {
        try {
            return this.objectMapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new EzyCodecException("write value as bytes error", (Throwable)e);
        }
    }

    protected void addParserMap(Map<Class<?>, Map<Class<?>, EzyParser>> parserMaps) {
        ConcurrentHashMap<Class<ByteBuffer>, EzyParser> objectParsers = new ConcurrentHashMap<Class<ByteBuffer>, EzyParser>();
        objectParsers.put(byte[].class, this::writeValueAsBytes);
        objectParsers.put(String.class, this::writeValueAsString);
        objectParsers.put(ByteBuffer.class, input -> ByteBuffer.wrap(this.writeValueAsBytes(input)));
        parserMaps.put(EzyObject.class, objectParsers);
        ConcurrentHashMap<Class<ByteBuffer>, EzyParser> arrayParsers = new ConcurrentHashMap<Class<ByteBuffer>, EzyParser>();
        arrayParsers.put(byte[].class, this::writeValueAsBytes);
        arrayParsers.put(String.class, this::writeValueAsString);
        arrayParsers.put(ByteBuffer.class, input -> ByteBuffer.wrap(this.writeValueAsBytes(input)));
        parserMaps.put(EzyArray.class, arrayParsers);
    }
}

