/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.boot.mongodb;

import com.mongodb.MongoClient;
import com.tvd12.ezydata.database.EzyDatabaseContext;
import com.tvd12.ezydata.mongodb.EzyMongoDatabaseContextBuilder;
import com.tvd12.ezydata.mongodb.loader.EzySimpleMongoClientLoader;
import com.tvd12.ezyfox.annotation.EzyProperty;
import com.tvd12.ezyfox.bean.EzyBeanAutoConfig;
import com.tvd12.ezyfox.bean.EzyPackagesToScanAware;
import com.tvd12.ezyfox.bean.EzySingletonFactory;
import com.tvd12.ezyfox.bean.EzySingletonFactoryAware;
import com.tvd12.ezyfox.bean.annotation.EzyConfigurationBefore;
import com.tvd12.ezyfox.boot.util.EzyDatabaseContexts;
import com.tvd12.ezyfox.util.EzyPropertiesAware;
import java.util.Properties;
import java.util.Set;
import lombok.Generated;

@EzyConfigurationBefore
public class EzyMongoConfiguration
implements EzyBeanAutoConfig,
EzyPropertiesAware,
EzySingletonFactoryAware,
EzyPackagesToScanAware {
    @EzyProperty(value="database.mongo.database")
    private String databaseName;
    private Properties properties;
    private Set<String> packagesToScan;
    private EzySingletonFactory singletonFactory;

    public void autoConfig() {
        EzyDatabaseContexts.addRepositoriesFromDatabaseContextToSingletonFactory(this.newMongodbDatabaseContext(), this.singletonFactory);
    }

    private EzyDatabaseContext newMongodbDatabaseContext() {
        EzyMongoDatabaseContextBuilder builder = ((EzyMongoDatabaseContextBuilder)new EzyMongoDatabaseContextBuilder().properties(this.properties)).mongoClient(this.newMongoClient()).databaseName(this.databaseName);
        for (String p : this.packagesToScan) {
            builder.scan(p);
        }
        return builder.build();
    }

    protected MongoClient newMongoClient() {
        return EzySimpleMongoClientLoader.load((Properties)this.properties);
    }

    @Generated
    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    @Generated
    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    @Generated
    public void setPackagesToScan(Set<String> packagesToScan) {
        this.packagesToScan = packagesToScan;
    }

    @Generated
    public void setSingletonFactory(EzySingletonFactory singletonFactory) {
        this.singletonFactory = singletonFactory;
    }
}

