/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.bean.impl;

import com.tvd12.ezyfox.bean.EzySingletonFactory;
import com.tvd12.ezyfox.bean.impl.EzyBeanKey;
import com.tvd12.ezyfox.bean.impl.EzyBeanNameParser;
import com.tvd12.ezyfox.bean.impl.EzyKeyValueParser;
import com.tvd12.ezyfox.bean.impl.EzySimpleBeanFactory;
import com.tvd12.ezyfox.io.EzyMaps;
import com.tvd12.ezyfox.reflect.EzyClasses;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import lombok.Generated;

public class EzySimpleSingletonFactory
extends EzySimpleBeanFactory
implements EzySingletonFactory {
    protected final Set<Class> singletonClasses = new HashSet<Class>();
    protected final Set<Object> singletonSet = new HashSet<Object>();
    protected final Set<Object> completedSingletons = new HashSet<Object>();
    protected final Map<EzyBeanKey, Object> singletonByKey = new ConcurrentHashMap<EzyBeanKey, Object>();
    protected final Map<Object, Map> propertiesBySingleton = new ConcurrentHashMap<Object, Map>();

    void addCompletedSingleton(Object singleton) {
        this.completedSingletons.add(singleton);
    }

    boolean isCompletedSingleton(Object singleton) {
        return this.completedSingletons.contains(singleton);
    }

    @Override
    public Object addSingleton(Object singleton) {
        Class<?> type = singleton.getClass();
        return this.addSingleton(this.getBeanName(type), singleton);
    }

    @Override
    public Object addSingleton(String name, Object singleton) {
        Class<?> type = singleton.getClass();
        return this.addSingleton(name, singleton, this.getPropertiesByType(type));
    }

    @Override
    public Object addSingleton(String name, Object singleton, Map properties) {
        Class<?> type = singleton.getClass();
        EzyBeanKey key = EzyBeanKey.of(name, type);
        Object existed = this.singletonByKey.get(key);
        if (existed != null) {
            return existed;
        }
        this.singletonSet.add(singleton);
        this.singletonByKey.put(key, singleton);
        this.propertiesBySingleton.put(singleton, properties);
        String defaultBeanName = this.getDefaultBeanName(type);
        this.mapBeanName(defaultBeanName, type, name);
        Set subTypes = EzyClasses.flatSuperAndInterfaceClasses(type, (boolean)true);
        for (Class subType : subTypes) {
            this.checkAndAddSingleton(name, subType, singleton);
        }
        return singleton;
    }

    private void checkAndAddSingleton(String name, Class<?> type, Object singleton) {
        EzyBeanKey key = EzyBeanKey.of(name, type);
        if (this.singletonByKey.containsKey(key)) {
            return;
        }
        this.singletonByKey.put(key, singleton);
    }

    @Override
    public void addSingletons(Map<String, Object> singletons) {
        for (String name : singletons.keySet()) {
            this.addSingleton(name, singletons.get(name));
        }
    }

    @Override
    public void addSingletonsByBeanKey(Map<EzyBeanKey, Object> singletons) {
        for (EzyBeanKey key : singletons.keySet()) {
            Object singleton = singletons.get(key);
            Class<?> type = singleton.getClass();
            Map properties = this.getPropertiesByType(type);
            this.singletonClasses.add(type);
            this.singletonSet.add(singleton);
            this.singletonByKey.put(key, singleton);
            this.propertiesBySingleton.put(singleton, properties);
        }
    }

    @Override
    public Object getSingleton(Class type) {
        String name = this.getBeanName(type);
        return this.getSingleton(name, type);
    }

    @Override
    public Object getSingleton(String name, Class type) {
        String realName = this.translateBeanName(name, type);
        Object singleton = this.singletonByKey.get(EzyBeanKey.of(realName, type));
        if (singleton == null) {
            for (EzyBeanKey key : this.singletonByKey.keySet()) {
                if (!type.isAssignableFrom(key.getType())) continue;
                singleton = this.singletonByKey.get(key);
                break;
            }
        }
        return singleton;
    }

    @Override
    public Object getSingleton(EzyBeanKey key) {
        return this.singletonByKey.get(key);
    }

    @Override
    public Object getSingleton(Map properties) {
        for (Map.Entry<Object, Map> entry : this.propertiesBySingleton.entrySet()) {
            if (!EzyMaps.containsAll((Map)entry.getValue(), (Map)properties)) continue;
            return entry.getKey();
        }
        return null;
    }

    @Override
    public Object getAnnotatedSingleton(Class annotationClass) {
        List list = this.getSingletons(annotationClass);
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public List getSingletons() {
        return new ArrayList<Object>(this.singletonSet);
    }

    @Override
    public List getSingletons(Map properties) {
        HashSet<Object> set = new HashSet<Object>();
        for (Map.Entry<Object, Map> entry : this.propertiesBySingleton.entrySet()) {
            if (!EzyMaps.containsAll((Map)entry.getValue(), (Map)properties)) continue;
            set.add(entry.getKey());
        }
        return new ArrayList(set);
    }

    @Override
    public List getSingletons(Class ... annotationClasses) {
        return this.getSingletons((T o) -> {
            for (Class annotationClass : annotationClasses) {
                if (!o.getClass().isAnnotationPresent(annotationClass)) continue;
                return true;
            }
            return false;
        });
    }

    @Override
    public List getSingletons(Predicate filter) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object object : this.singletonSet) {
            if (!filter.test(object)) continue;
            list.add(object);
        }
        return list;
    }

    @Override
    public List getSingletonsOf(Class parentClass) {
        return this.getSingletons((T o) -> parentClass.isAssignableFrom(o.getClass()));
    }

    @Override
    public Map<EzyBeanKey, Object> getSingletonMapByKey() {
        return new HashMap<EzyBeanKey, Object>(this.singletonByKey);
    }

    @Override
    public Map getProperties(Object singleton) {
        return this.propertiesBySingleton.get(singleton);
    }

    public void addSingletonClasses(Set<Class> classes) {
        this.singletonClasses.addAll(classes);
    }

    private String getBeanName(Class<?> type) {
        return EzyBeanNameParser.getSingletonName(type);
    }

    private Map getPropertiesByType(Class<?> type) {
        return EzyKeyValueParser.getSingletonProperties(type);
    }

    @Override
    @Generated
    public Set<Class> getSingletonClasses() {
        return this.singletonClasses;
    }
}

