/*
 * Decompiled with CFR 0.152.
 */
package com.ezyplatform.socket.monitor.plugin.data;

import com.ezyplatform.socket.monitor.plugin.data.TrafficDetail;
import com.tvd12.ezyfox.binding.annotation.EzyObjectBinding;
import com.tvd12.ezyfoxserver.statistics.EzyComponentStatistics;
import com.tvd12.ezyfoxserver.statistics.EzySocketStatistics;
import com.tvd12.ezyfoxserver.statistics.EzyStatistics;
import com.tvd12.ezyfoxserver.statistics.EzyUserStatistics;
import com.tvd12.ezyfoxserver.statistics.EzyWebSocketStatistics;

@EzyObjectBinding(read=false)
public class TrafficDetails {
    protected int maxUser;
    protected int totalUser;
    protected TrafficDetail socket;
    protected TrafficDetail wesocket;

    public TrafficDetails(EzyStatistics statistics) {
        EzyUserStatistics userStatistics = statistics.getUserStats();
        EzySocketStatistics socketStatistics = statistics.getSocketStats();
        EzyWebSocketStatistics webSocketStatistics = statistics.getWebSocketStats();
        this.maxUser = userStatistics.getMaxUsers();
        this.totalUser = userStatistics.getTotalUsers();
        this.socket = new TrafficDetail((EzyComponentStatistics)socketStatistics);
        this.wesocket = new TrafficDetail((EzyComponentStatistics)webSocketStatistics);
    }

    public int getMaxSession() {
        return this.socket.getMaxSession() + this.wesocket.getMaxSession();
    }

    public int getTotalSession() {
        return this.socket.getTotalSession() + this.wesocket.getTotalSession();
    }

    public long getTotalReadPackets() {
        return this.socket.getTotalReadPackets() + this.wesocket.getTotalReadPackets();
    }

    public long getTotalWrittenPackets() {
        return this.socket.getTotalWrittenPackets() + this.wesocket.getTotalWrittenPackets();
    }

    public long getTotalDroppedInPackets() {
        return this.socket.getTotalDroppedInPackets() + this.wesocket.getTotalDroppedInPackets();
    }

    public long getTotalDroppedOutPackets() {
        return this.socket.getTotalDroppedOutPackets() + this.wesocket.getTotalDroppedOutPackets();
    }

    public long getTransferredInputData() {
        return this.socket.getTransferredInputData() + this.wesocket.getTransferredInputData();
    }

    public long getTransferredOutputData() {
        return this.socket.getTransferredOutputData() + this.wesocket.getTransferredOutputData();
    }

    public long getCurrentInputDataTransferRate() {
        return this.socket.getCurrentInputDataTransferRate() + this.wesocket.getCurrentInputDataTransferRate();
    }

    public long getCurrentOutputDataTransferRate() {
        return this.socket.getCurrentOutputDataTransferRate() + this.socket.getCurrentOutputDataTransferRate();
    }

    public int getMaxUser() {
        return this.maxUser;
    }

    public int getTotalUser() {
        return this.totalUser;
    }

    public TrafficDetail getSocket() {
        return this.socket;
    }

    public TrafficDetail getWesocket() {
        return this.wesocket;
    }
}

