/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.installer.io;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Stack;

public class InstallFolderProxy {
    private InstallFolderProxy() {
    }

    public static Path getLogsFolder() {
        return InstallFolderProxy.getFilePath("logs", new String[0]);
    }

    public static Path getUpdateFilesPath() {
        return InstallFolderProxy.getFilePath("upload/platforms/ezyplatform", "update-files.txt");
    }

    public static Path getNewModulesFilesPath() {
        return InstallFolderProxy.getFilePath("upload/platforms/ezyplatform", "new-modules");
    }

    public static Path getUploadEzyPlatformFolder() {
        return InstallFolderProxy.getFilePath("upload/platforms/ezyplatform", new String[0]);
    }

    public static Path getFilePath(String firstPath, String ... paths) {
        Path path = Paths.get(firstPath, paths);
        if (!Files.exists(path, new LinkOption[0])) {
            String homePath = System.getProperty("EZYPLATFORM_HOME");
            if (homePath == null) {
                homePath = System.getenv("EZYPLATFORM_HOME");
            }
            if (homePath == null) {
                homePath = System.getProperty("ezyplatform.home");
            }
            if (homePath == null) {
                homePath = System.getenv("ezyplatform.home");
            }
            if (homePath != null) {
                Paths.get(homePath, path.toString());
            }
        }
        return path;
    }

    public static void deleteFolder(Path folder) throws IOException {
        Stack<File> stack = new Stack<File>();
        stack.push(folder.toFile());
        while (stack.size() > 0) {
            File parent = (File)stack.pop();
            File[] fileList = parent.listFiles();
            if (fileList == null || fileList.length == 0) {
                Files.deleteIfExists(parent.toPath());
                continue;
            }
            stack.push(parent);
            for (File child : fileList) {
                if (child.isDirectory()) {
                    stack.push(child);
                    continue;
                }
                Files.delete(child.toPath());
            }
        }
    }

    public static void copyFolder(Path from, Path to) throws IOException {
        if (!Files.exists(from, new LinkOption[0])) {
            return;
        }
        Stack<File> stack = new Stack<File>();
        stack.push(from.toFile());
        while (stack.size() > 0) {
            File parent = (File)stack.pop();
            File[] fileList = parent.listFiles();
            if (fileList == null) continue;
            for (File child : fileList) {
                if (child.isDirectory()) {
                    stack.push(child);
                    continue;
                }
                File toFile = Paths.get(to.toString(), InstallFolderProxy.subpath(child.toPath(), from).toString()).toFile();
                InstallFolderProxy.copyFile(child.toPath(), toFile.toPath());
            }
        }
    }

    public static void copyFile(Path from, Path to) throws IOException {
        InstallFolderProxy.createFileIfNotExists(to);
        Files.copy(from, to, StandardCopyOption.REPLACE_EXISTING);
    }

    public static void createFileIfNotExists(Path file) throws IOException {
        if (!Files.exists(file, new LinkOption[0])) {
            Path parentFile = file.getParent();
            if (parentFile != null && !Files.exists(parentFile, new LinkOption[0])) {
                Files.createDirectories(parentFile, new FileAttribute[0]);
            }
            Files.createFile(file, new FileAttribute[0]);
        }
    }

    public static Path subpath(Path fullPath, Path rootPath) {
        return fullPath.subpath(rootPath.getNameCount(), fullPath.getNameCount());
    }
}

