/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.support.asm;

import com.tvd12.ezyfox.asm.EzyFunction;
import com.tvd12.ezyfox.asm.EzyInstruction;
import com.tvd12.ezyfox.reflect.EzyClass;
import com.tvd12.ezyfox.reflect.EzyClassTree;
import com.tvd12.ezyfox.reflect.EzyMethod;
import com.tvd12.ezyfox.reflect.EzyMethods;
import com.tvd12.ezyfoxserver.context.EzyContext;
import com.tvd12.ezyfoxserver.event.EzyUserSessionEvent;
import com.tvd12.ezyfoxserver.support.asm.EzyAbstractHandlerImplementer;
import com.tvd12.ezyfoxserver.support.asm.EzyAsmAbstractRequestHandler;
import com.tvd12.ezyfoxserver.support.asm.EzyAsmRequestHandler;
import com.tvd12.ezyfoxserver.support.factory.EzyResponseFactory;
import com.tvd12.ezyfoxserver.support.reflect.EzyExceptionHandlerMethod;
import com.tvd12.ezyfoxserver.support.reflect.EzyRequestControllerProxy;
import com.tvd12.ezyfoxserver.support.reflect.EzyRequestHandlerMethod;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtNewMethod;
import lombok.Generated;

public class EzyRequestHandlerImplementer
extends EzyAbstractHandlerImplementer<EzyRequestHandlerMethod> {
    private static boolean debug;
    protected EzyResponseFactory responseFactory;
    protected final EzyRequestControllerProxy controller;
    protected static final AtomicInteger COUNT;

    public EzyRequestHandlerImplementer(EzyRequestControllerProxy controller, EzyRequestHandlerMethod handlerMethod) {
        super(handlerMethod);
        this.controller = controller;
    }

    public EzyAsmRequestHandler implement() {
        try {
            return this.doImplement();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    protected EzyAsmRequestHandler doImplement() throws Exception {
        ClassPool pool = ClassPool.getDefault();
        String implClassName = this.getImplClassName();
        CtClass implClass = pool.makeClass(implClassName);
        EzyClass superClass = new EzyClass(this.getSuperClass());
        String controllerFieldContent = this.makeControllerFieldContent();
        String setControllerMethodContent = this.makeSetControllerMethodContent();
        String handleRequestMethodContent = this.makeHandleRequestMethodContent();
        String handleExceptionMethodContent = this.makeHandleExceptionMethodContent();
        String getRequestDataTypeMethodContent = this.makeGetRequestDataTypeMethodContent();
        this.printComponentContent(controllerFieldContent);
        this.printComponentContent(setControllerMethodContent);
        this.printComponentContent(handleRequestMethodContent);
        this.printComponentContent(handleExceptionMethodContent);
        this.printComponentContent(getRequestDataTypeMethodContent);
        implClass.setSuperclass(pool.get(superClass.getName()));
        implClass.addField(CtField.make((String)controllerFieldContent, (CtClass)implClass));
        implClass.addMethod(CtNewMethod.make((String)setControllerMethodContent, (CtClass)implClass));
        implClass.addMethod(CtNewMethod.make((String)handleRequestMethodContent, (CtClass)implClass));
        implClass.addMethod(CtNewMethod.make((String)handleExceptionMethodContent, (CtClass)implClass));
        implClass.addMethod(CtNewMethod.make((String)getRequestDataTypeMethodContent, (CtClass)implClass));
        Class answerClass = implClass.toClass();
        implClass.detach();
        EzyAsmRequestHandler handler = (EzyAsmRequestHandler)answerClass.newInstance();
        handler.setCommand(((EzyRequestHandlerMethod)this.handlerMethod).getCommand());
        handler.setResponseFactory(this.responseFactory);
        this.setRepoComponent(handler);
        return handler;
    }

    protected void setRepoComponent(EzyAsmRequestHandler handler) {
        handler.setController(this.controller.getInstance());
    }

    protected String makeControllerFieldContent() {
        return new EzyInstruction().append("private ").append(this.controller.getClazz().getName()).append(" controller").toString();
    }

    protected String makeSetControllerMethodContent() {
        return new EzyFunction(this.getSetControllerMethod()).body().append(new EzyInstruction("\t", "\n").append("this.controller").equal().brackets(this.controller.getClazz().getClazz()).append("arg0")).function().toString();
    }

    protected String makeHandleRequestMethodContent() {
        EzyMethod method = this.getHandleRequestMethod();
        EzyFunction function = new EzyFunction(method).throwsException();
        EzyFunction.EzyBody body = function.body();
        int paramCount = this.prepareHandleMethodArguments(body);
        EzyInstruction instruction = new EzyInstruction("\t", "\n");
        StringBuilder answerExpression = new StringBuilder();
        if (((EzyRequestHandlerMethod)this.handlerMethod).getReturnType() != Void.TYPE) {
            answerExpression.append(Object.class.getName()).append(" data = ");
        }
        answerExpression.append("this.controller.").append(((EzyRequestHandlerMethod)this.handlerMethod).getName()).append("(");
        for (int i = 0; i < paramCount; ++i) {
            answerExpression.append("param").append(i);
            if (i >= paramCount - 1) continue;
            answerExpression.append(", ");
        }
        answerExpression.append(")");
        instruction.append((Object)answerExpression);
        body.append(instruction);
        if (((EzyRequestHandlerMethod)this.handlerMethod).getReturnType() != Void.TYPE) {
            EzyInstruction responseInstruction = new EzyInstruction("\t", "\n").invoke("this", "responseToSession", new String[]{"arg1", "data"});
            body.append(responseInstruction);
        }
        return function.toString();
    }

    protected String makeHandleExceptionMethodContent() {
        EzyMethod method = this.getHandleExceptionMethod();
        EzyFunction function = new EzyFunction(method).throwsException();
        EzyFunction.EzyBody body = function.body();
        Map<Class<?>, EzyExceptionHandlerMethod> exceptionHandlerMethodMap = this.controller.getExceptionHandlerMethodMap();
        Set<Class<?>> exceptionClasses = exceptionHandlerMethodMap.keySet();
        EzyClassTree exceptionTree = new EzyClassTree(exceptionClasses);
        for (Class exceptionClass : exceptionTree.toList()) {
            EzyExceptionHandlerMethod m = exceptionHandlerMethodMap.get(exceptionClass);
            EzyInstruction instructionIf = new EzyInstruction("\t", "\n", false).append("if(arg3 instanceof ").append(exceptionClass.getName()).append(") {");
            body.append(instructionIf);
            EzyInstruction instructionHandle = new EzyInstruction("\t\t", "\n");
            instructionHandle.append("this.controller.").append(m.getName()).bracketopen();
            this.appendHandleExceptionMethodArguments(m, instructionHandle, exceptionClass);
            instructionHandle.bracketclose();
            body.append(instructionHandle);
            body.append(new EzyInstruction("\t", "\n", false).append("}"));
        }
        if (exceptionClasses.size() > 0) {
            body.append(new EzyInstruction("\t", "\n", false).append("else {"));
            body.append(new EzyInstruction("\t\t", "\n").append("throw arg3"));
            body.append(new EzyInstruction("\t", "\n", false).append("}"));
        } else {
            body.append(new EzyInstruction("\t", "\n").append("throw arg3"));
        }
        return function.toString();
    }

    protected void appendHandleExceptionMethodArguments(EzyExceptionHandlerMethod method, EzyInstruction instruction, Class<?> exceptionClass) {
        super.appendHandleExceptionMethodArguments(method, instruction, exceptionClass, "this.command", "arg2", "arg3");
    }

    protected String makeGetRequestDataTypeMethodContent() {
        EzyInstruction answerInstruction = new EzyInstruction("\t", "\n").answer();
        if (((EzyRequestHandlerMethod)this.handlerMethod).getRequestDataType() == null) {
            answerInstruction.append("null");
        } else {
            answerInstruction.clazz(((EzyRequestHandlerMethod)this.handlerMethod).getRequestDataType(), true);
        }
        return new EzyFunction(this.getGetResponseContentTypeMethod()).body().append(answerInstruction).function().toString();
    }

    protected EzyMethod getSetControllerMethod() {
        Method method = EzyMethods.getMethod(EzyAsmAbstractRequestHandler.class, (String)"setController", (Class[])new Class[]{Object.class});
        return new EzyMethod(method);
    }

    protected EzyMethod getHandleRequestMethod() {
        Method method = EzyMethods.getMethod(EzyAsmAbstractRequestHandler.class, (String)"handleRequest", (Class[])new Class[]{EzyContext.class, EzyUserSessionEvent.class, Object.class});
        return new EzyMethod(method);
    }

    protected EzyMethod getHandleExceptionMethod() {
        Method method = EzyMethods.getMethod(EzyAsmAbstractRequestHandler.class, (String)"handleException", (Class[])new Class[]{EzyContext.class, EzyUserSessionEvent.class, Object.class, Exception.class});
        return new EzyMethod(method);
    }

    protected EzyMethod getGetResponseContentTypeMethod() {
        Method method = EzyMethods.getMethod(EzyAsmAbstractRequestHandler.class, (String)"getDataType", (Class[])new Class[0]);
        return new EzyMethod(method);
    }

    protected Class<?> getSuperClass() {
        return EzyAsmAbstractRequestHandler.class;
    }

    protected String getImplClassName() {
        return this.controller.getControllerName() + "$" + ((EzyRequestHandlerMethod)this.handlerMethod).getName() + "$Handler$AutoImpl$" + COUNT.incrementAndGet();
    }

    protected void printComponentContent(String componentContent) {
        if (debug) {
            this.logger.debug("component content: \n{}", (Object)componentContent);
        }
    }

    @Generated
    public static void setDebug(boolean debug) {
        EzyRequestHandlerImplementer.debug = debug;
    }

    @Generated
    public void setResponseFactory(EzyResponseFactory responseFactory) {
        this.responseFactory = responseFactory;
    }

    static {
        COUNT = new AtomicInteger(0);
    }
}

